/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class LoadPropertiesAction
extends AbstractTestAction {
    private final String filePath;
    private static Logger log = LoggerFactory.getLogger(LoadPropertiesAction.class);

    public LoadPropertiesAction(Builder builder) {
        super("load", builder);
        this.filePath = builder.filePath;
    }

    @Override
    public void doExecute(TestContext context) {
        Properties props;
        Resource resource = FileUtils.getFileResource(this.filePath, context);
        if (log.isDebugEnabled()) {
            log.debug("Reading property file " + resource.getFilename());
        }
        try {
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next().getKey().toString();
            if (log.isDebugEnabled()) {
                log.debug("Loading property: " + key + "=" + props.getProperty(key) + " into variables");
            }
            if (log.isDebugEnabled() && context.getVariables().containsKey(key)) {
                log.debug("Overwriting property " + key + " old value:" + context.getVariable(key) + " new value:" + props.getProperty(key));
            }
            context.setVariable(key, (Object)context.replaceDynamicContentInString(props.getProperty(key)));
        }
        log.info("Loaded property file " + resource.getFilename());
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<LoadPropertiesAction, Builder> {
        private String filePath;

        public static Builder load(String filePath) {
            Builder builder = new Builder();
            builder.filePath(filePath);
            return builder;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public LoadPropertiesAction build() {
            return new LoadPropertiesAction(this);
        }
    }
}

