/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepAction
extends AbstractTestAction {
    private final String time;
    private final TimeUnit timeUnit;
    private static Logger log = LoggerFactory.getLogger(SleepAction.class);

    private SleepAction(Builder builder) {
        super("sleep", builder);
        this.time = builder.time;
        this.timeUnit = builder.timeUnit;
    }

    @Override
    public void doExecute(TestContext context) {
        String duration = context.resolveDynamicValue(this.time);
        try {
            log.info(String.format("Sleeping %s %s", duration, this.timeUnit.toString()));
            this.timeUnit.sleep(Long.parseLong(duration));
            log.info(String.format("Returning after %s %s", duration, this.timeUnit.toString()));
        }
        catch (InterruptedException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public String getTime() {
        return this.time;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<SleepAction, Builder> {
        private String time = "5000";
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public static Builder sleep() {
            return new Builder();
        }

        public Builder milliseconds(long milliseconds) {
            this.time = String.valueOf(milliseconds);
            this.timeUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public Builder seconds(double seconds) {
            this.milliseconds(Math.round(seconds * 1000.0));
            return this;
        }

        public Builder time(Duration duration) {
            this.milliseconds(duration.toMillis());
            return this;
        }

        public Builder time(String expression) {
            this.time(expression, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder time(String expression, TimeUnit timeUnit) {
            this.time = expression;
            this.timeUnit = timeUnit;
            return this;
        }

        public SleepAction build() {
            return new SleepAction(this);
        }
    }
}

