/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.condition;

import com.consol.citrus.condition.AbstractCondition;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCondition
extends AbstractCondition {
    private String url;
    private String timeout = "1000";
    private String httpResponseCode = "200";
    private String method = "HEAD";
    private static Logger log = LoggerFactory.getLogger(HttpCondition.class);

    public HttpCondition() {
        super("http-check");
    }

    public boolean isSatisfied(TestContext context) {
        return this.getHttpResponseCode(context) == this.invokeUrl(context);
    }

    public String getSuccessMessage(TestContext context) {
        return String.format("Http condition success - request url '%s' did return expected status '%s'", this.getUrl(context), this.getHttpResponseCode(context));
    }

    public String getErrorMessage(TestContext context) {
        return String.format("Failed to check Http condition - request url '%s' did not return expected status '%s'", this.getUrl(context), this.getHttpResponseCode(context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invokeUrl(TestContext context) {
        URL contextUrl = this.getUrl(context);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Probing Http request url '%s'", contextUrl.toExternalForm()));
        }
        int responseCode = -1;
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.openConnection(contextUrl);
            httpURLConnection.setConnectTimeout(this.getTimeout(context));
            httpURLConnection.setRequestMethod(context.resolveDynamicValue(this.method));
            responseCode = httpURLConnection.getResponseCode();
        }
        catch (IOException e) {
            log.warn(String.format("Could not access Http url '%s' - %s", contextUrl.toExternalForm(), e.getMessage()));
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return responseCode;
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private URL getUrl(TestContext context) {
        try {
            return new URL(context.replaceDynamicContentInString(this.url));
        }
        catch (MalformedURLException e) {
            throw new CitrusRuntimeException("Invalid request url", (Throwable)e);
        }
    }

    private int getTimeout(TestContext context) {
        return Integer.parseInt(context.resolveDynamicValue(this.timeout));
    }

    private int getHttpResponseCode(TestContext context) {
        return Integer.parseInt(context.resolveDynamicValue(this.httpResponseCode));
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public void setHttpResponseCode(String httpResponseCode) {
        this.httpResponseCode = httpResponseCode;
    }

    public String toString() {
        return "HttpCondition{url='" + this.url + '\'' + ", timeout='" + this.timeout + '\'' + ", httpResponseCode='" + this.httpResponseCode + '\'' + ", method='" + this.method + '\'' + ", name='" + this.getName() + '\'' + '}';
    }
}

