/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.condition;

import com.consol.citrus.condition.AbstractCondition;
import com.consol.citrus.context.TestContext;

public class MessageCondition
extends AbstractCondition {
    private String messageName;

    public boolean isSatisfied(TestContext context) {
        return context.getMessageStore().getMessage(context.replaceDynamicContentInString(this.messageName)) != null;
    }

    public String getSuccessMessage(TestContext context) {
        return String.format("Message condition success - found message '%s' in message store", context.replaceDynamicContentInString(this.messageName));
    }

    public String getErrorMessage(TestContext context) {
        return String.format("Message condition failed - unable to find message '%s' in message store", context.replaceDynamicContentInString(this.messageName));
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    public String getMessageName() {
        return this.messageName;
    }

    public String toString() {
        return "MessageCondition{messageName='" + this.messageName + '\'' + ", name='" + this.getName() + '\'' + '}';
    }
}

