/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.AbstractAsyncTestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async
extends AbstractActionContainer {
    private static Logger log = LoggerFactory.getLogger(Async.class);
    private final List<TestActionBuilder<?>> errorActions;
    private final List<TestActionBuilder<?>> successActions;

    public Async(Builder builder) {
        super("async", builder);
        this.successActions = builder.successActions;
        this.errorActions = builder.errorActions;
    }

    @Override
    public void doExecute(TestContext context) {
        log.debug("Async container forking action execution ...");
        AbstractAsyncTestAction asyncTestAction = new AbstractAsyncTestAction(){

            @Override
            public void doExecuteAsync(TestContext context) {
                for (TestActionBuilder actionBuilder : Async.this.actions) {
                    TestAction action = actionBuilder.build();
                    Async.this.setActiveAction(action);
                    action.execute(context);
                }
            }

            @Override
            public void onError(TestContext context, Throwable error) {
                log.info("Apply error actions after async container ...");
                for (TestActionBuilder actionBuilder : Async.this.errorActions) {
                    TestAction action = actionBuilder.build();
                    action.execute(context);
                }
            }

            @Override
            public void onSuccess(TestContext context) {
                log.info("Apply success actions after async container ...");
                for (TestActionBuilder actionBuilder : Async.this.successActions) {
                    TestAction action = actionBuilder.build();
                    action.execute(context);
                }
            }
        };
        this.setActiveAction(asyncTestAction);
        asyncTestAction.execute(context);
    }

    public List<TestAction> getSuccessActions() {
        return this.successActions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public List<TestAction> getErrorActions() {
        return this.errorActions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractTestContainerBuilder<Async, Builder> {
        private List<TestActionBuilder<?>> errorActions = new ArrayList();
        private List<TestActionBuilder<?>> successActions = new ArrayList();

        public static Builder async() {
            return new Builder();
        }

        public Builder errorAction(TestAction action) {
            this.errorActions.add(() -> action);
            return this;
        }

        public Builder successAction(TestAction action) {
            this.successActions.add(() -> action);
            return this;
        }

        public Builder errorAction(TestActionBuilder<?> action) {
            this.errorActions.add(action);
            return this;
        }

        public Builder successAction(TestActionBuilder<?> action) {
            this.successActions.add(action);
            return this;
        }

        public Builder errorActions(TestActionBuilder<?> ... actions) {
            this.errorActions.addAll(Arrays.asList(actions));
            return this;
        }

        public Builder successActions(TestActionBuilder<?> ... actions) {
            this.successActions.addAll(Arrays.asList(actions));
            return this;
        }

        public Builder errorActions(TestAction ... actions) {
            Stream.of(actions).map(action -> () -> action).forEach(this::errorAction);
            return this;
        }

        public Builder successActions(TestAction ... actions) {
            Stream.of(actions).map(action -> () -> action).forEach(this::successAction);
            return this;
        }

        @Override
        public Async build() {
            return this.doBuild();
        }

        @Override
        protected Async doBuild() {
            return new Async(this);
        }
    }
}

