/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.main.scan;

import com.consol.citrus.TestClass;
import com.consol.citrus.main.scan.AbstractTestScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.filter.AbstractClassTestingTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ReflectionUtils;

public class ClassPathTestScanner
extends AbstractTestScanner {
    private static Logger log = LoggerFactory.getLogger(ClassPathTestScanner.class);
    private final Class<? extends Annotation> annotationType;

    public ClassPathTestScanner(Class<? extends Annotation> annotationType, String ... includes) {
        super(includes);
        this.annotationType = annotationType;
    }

    public List<TestClass> findTestsInPackage(String packageName) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AbstractClassTestingTypeFilter(){

            protected boolean match(ClassMetadata metadata) {
                if (!ClassPathTestScanner.this.isIncluded(metadata.getClassName())) {
                    return false;
                }
                try {
                    Class<?> clazz = Class.forName(metadata.getClassName());
                    if (clazz.isAnnotationPresent(ClassPathTestScanner.this.annotationType)) {
                        return true;
                    }
                    AtomicBoolean hasTestMethod = new AtomicBoolean(false);
                    ReflectionUtils.doWithMethods(clazz, method -> hasTestMethod.set(true), method -> AnnotationUtils.findAnnotation((Method)method, (Class)ClassPathTestScanner.this.annotationType) != null);
                    return hasTestMethod.get();
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    log.warn("Unable to access class: " + metadata.getClassName());
                    return false;
                }
            }
        });
        return provider.findCandidateComponents(packageName).stream().map(BeanDefinition::getBeanClassName).distinct().map(TestClass::new).collect(Collectors.toList());
    }
}

