/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.MessageUtils;
import com.consol.citrus.util.TypeConversionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.util.CollectionUtils;

public class DefaultMessage
implements Message {
    private static final long serialVersionUID = 1904510540660648952L;
    private Object payload;
    private final List<String> headerData = new ArrayList<String>();
    private final Map<String, Object> headers = new LinkedHashMap<String, Object>();
    private String name;
    private String type;

    public DefaultMessage() {
        this("");
    }

    public DefaultMessage(Message message) {
        this(message.getPayload(), message.getHeaders());
        this.setName(message.getName());
        this.setType(message.getType());
        this.headerData.addAll(message.getHeaderData());
    }

    public DefaultMessage(Object payload) {
        this(payload, new LinkedHashMap<String, Object>());
    }

    public DefaultMessage(Object payload, Map<String, Object> headers) {
        this.payload = payload;
        this.headers.putAll(headers);
        this.headers.putIfAbsent("citrus_message_id", UUID.randomUUID().toString());
        this.headers.putIfAbsent("citrus_message_timestamp", System.currentTimeMillis());
    }

    public String getId() {
        return this.getHeader("citrus_message_id").toString();
    }

    public Long getTimestamp() {
        return (Long)this.getHeader("citrus_message_timestamp");
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.headerData)) {
            return this.getClass().getSimpleName().toUpperCase() + " [id: " + this.getId() + ", payload: " + this.getPayload(String.class).trim() + "][headers: " + Collections.unmodifiableMap(this.headers) + "]";
        }
        return this.getClass().getSimpleName().toUpperCase() + " [id: " + this.getId() + ", payload: " + this.getPayload(String.class).trim() + "][headers: " + Collections.unmodifiableMap(this.headers) + "][header-data: " + Collections.unmodifiableList(this.headerData) + "]";
    }

    public DefaultMessage setHeader(String headerName, Object headerValue) {
        if (headerName.equals("citrus_message_id")) {
            throw new CitrusRuntimeException("Not allowed to set reserved message header: citrus_message_id");
        }
        this.headers.put(headerName, headerValue);
        return this;
    }

    public Object getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public void removeHeader(String headerName) {
        if (headerName.equals("citrus_message_id")) {
            throw new CitrusRuntimeException("Not allowed to remove reserved message header from message: citrus_message_id");
        }
        this.headers.remove(headerName);
    }

    public DefaultMessage addHeaderData(String headerData) {
        this.headerData.add(headerData);
        return this;
    }

    public List<String> getHeaderData() {
        return this.headerData;
    }

    public <T> T getPayload(Class<T> type) {
        return (T)TypeConversionUtils.convertIfNecessary((Object)this.getPayload(), type);
    }

    public Object getPayload() {
        return this.payload;
    }

    public DefaultMessage setPayload(Object payload) {
        this.payload = payload;
        return this;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public DefaultMessage setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DefaultMessage setType(MessageType type) {
        this.type = type.name();
        return this;
    }

    public DefaultMessage setType(String type) {
        if (type != null) {
            this.headers.put("citrus_message_type", type);
        }
        this.type = type;
        return this;
    }

    public String getType() {
        if (this.type == null) {
            this.type = MessageUtils.hasJsonPayload(this) ? MessageType.JSON.name() : (MessageUtils.hasXmlPayload(this) ? MessageType.XML.name() : (this.getPayload() instanceof String ? MessageType.PLAINTEXT.name() : (!CitrusSettings.DEFAULT_MESSAGE_TYPE.equals(MessageType.XML.name()) && !CitrusSettings.DEFAULT_MESSAGE_TYPE.equals(MessageType.JSON.name()) ? CitrusSettings.DEFAULT_MESSAGE_TYPE : MessageType.UNSPECIFIED.name())));
        }
        return this.type;
    }
}

