/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.builder;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.MessageHeaderDataBuilder;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;

public class FileResourceHeaderDataBuilder
implements MessageHeaderDataBuilder {
    private final String charsetName;
    private final String resourcePath;

    public FileResourceHeaderDataBuilder(String resourcePath) {
        this(resourcePath, CitrusSettings.CITRUS_FILE_ENCODING);
    }

    public FileResourceHeaderDataBuilder(String resourcePath, String charsetName) {
        this.charsetName = charsetName;
        this.resourcePath = resourcePath;
    }

    public String buildHeaderData(TestContext context) {
        try {
            return context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.resourcePath, context), Charset.forName(context.resolveDynamicValue(this.charsetName))));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read message header data resource", (Throwable)e);
        }
    }
}

