/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.builder.script;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.validation.script.TemplateBasedScriptBuilder;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import org.codehaus.groovy.control.CompilationFailedException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class GroovyScriptPayloadBuilder
implements MessagePayloadBuilder {
    private final Resource scriptTemplateResource = new ClassPathResource("com/consol/citrus/script/markup-builder-template.groovy");
    private final String script;

    public GroovyScriptPayloadBuilder(String script) {
        this.script = script;
    }

    public Object buildPayload(TestContext context) {
        return this.buildMarkupBuilderScript(context.replaceDynamicContentInString(this.script));
    }

    protected String buildMarkupBuilderScript(String scriptData) {
        try {
            ClassLoader parent = GroovyScriptPayloadBuilder.class.getClassLoader();
            GroovyClassLoader loader = new GroovyClassLoader(parent);
            Class groovyClass = loader.parseClass(TemplateBasedScriptBuilder.fromTemplateResource(this.scriptTemplateResource).withCode(scriptData).build());
            if (groovyClass == null) {
                throw new CitrusRuntimeException("Could not load groovy script!");
            }
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            return (String)groovyObject.invokeMethod("run", (Object)new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | CompilationFailedException e) {
            throw new CitrusRuntimeException(e);
        }
    }
}

