/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.CitrusVersion;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.common.Described;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.report.AbstractTestReporter;
import com.consol.citrus.report.MessageListener;
import com.consol.citrus.report.TestActionListener;
import com.consol.citrus.report.TestListener;
import com.consol.citrus.report.TestResults;
import com.consol.citrus.report.TestSuiteListener;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LoggingReporter
extends AbstractTestReporter
implements MessageListener,
TestSuiteListener,
TestListener,
TestActionListener {
    private static Logger inboundMsgLogger = LoggerFactory.getLogger((String)"Logger.Message_IN");
    private static Logger outboundMsgLogger = LoggerFactory.getLogger((String)"Logger.Message_OUT");
    private static Logger log = LoggerFactory.getLogger(LoggingReporter.class);

    @Override
    public void generate(TestResults testResults) {
        this.separator();
        this.newLine();
        this.info("CITRUS TEST RESULTS");
        this.newLine();
        testResults.doWithResults(testResult -> {
            this.info(testResult.toString());
            if (testResult.isFailed()) {
                this.info(Optional.ofNullable(testResult.getCause()).filter(cause -> StringUtils.hasText((String)cause.getMessage())).map(cause -> " FAILURE: Caused by: " + cause.getClass().getSimpleName() + ": " + cause.getMessage()).orElse(" FAILURE: Caused by: " + Optional.ofNullable(testResult.getErrorMessage()).orElse("Unknown error")));
            }
        });
        this.newLine();
        this.info("TOTAL:\t" + (testResults.getFailed() + testResults.getSuccess()));
        this.debug("SKIPPED:\t" + testResults.getSkipped() + " (" + testResults.getSkippedPercentage() + "%)");
        this.info("FAILED:\t" + testResults.getFailed() + " (" + testResults.getFailedPercentage() + "%)");
        this.info("SUCCESS:\t" + testResults.getSuccess() + " (" + testResults.getSuccessPercentage() + "%)");
        this.newLine();
        this.separator();
    }

    public void onTestFailure(TestCase test, Throwable cause) {
        this.newLine();
        this.error("TEST FAILED " + test.getName() + " <" + test.getPackageName() + "> Nested exception is: ", cause);
        this.separator();
        this.newLine();
    }

    public void onTestSkipped(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("SKIPPING TEST: " + test.getName());
            this.separator();
            this.newLine();
        }
    }

    public void onTestStart(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("STARTING TEST " + test.getName() + " <" + test.getPackageName() + ">");
            this.newLine();
        }
    }

    public void onTestFinish(TestCase test) {
    }

    public void onTestSuccess(TestCase test) {
        this.newLine();
        this.info("TEST SUCCESS " + test.getName() + " (" + test.getPackageName() + ")");
        this.separator();
        this.newLine();
    }

    public void onFinish() {
        this.newLine();
        this.separator();
        this.debug("AFTER TEST SUITE");
        this.newLine();
    }

    public void onStart() {
        this.newLine();
        this.separator();
        this.info("       .__  __                       ");
        this.info("  ____ |__|/  |________ __ __  ______");
        this.info("_/ ___\\|  \\   __\\_  __ \\  |  \\/  ___/");
        this.info("\\  \\___|  ||  |  |  | \\/  |  /\\___ \\ ");
        this.info(" \\___  >__||__|  |__|  |____//____  >");
        this.info("     \\/                           \\/");
        this.newLine();
        this.info("C I T R U S  T E S T S  " + CitrusVersion.version());
        this.newLine();
        this.separator();
        this.debug("BEFORE TEST SUITE");
        this.newLine();
    }

    public void onFinishFailure(Throwable cause) {
        this.newLine();
        this.info("AFTER TEST SUITE: FAILED");
        this.separator();
        this.newLine();
    }

    public void onFinishSuccess() {
        this.newLine();
        this.info("AFTER TEST SUITE: SUCCESS");
        this.separator();
        this.newLine();
    }

    public void onStartFailure(Throwable cause) {
        this.newLine();
        this.info("BEFORE TEST SUITE: FAILED");
        this.separator();
        this.newLine();
    }

    public void onStartSuccess() {
        this.newLine();
        this.info("BEFORE TEST SUITE: SUCCESS");
        this.separator();
        this.newLine();
    }

    public void onTestActionStart(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            }
            if (testAction instanceof TestActionContainer) {
                this.debug("TEST ACTION CONTAINER with " + ((TestActionContainer)testAction).getActionCount() + " embedded actions");
            }
            if (testAction instanceof Described && StringUtils.hasText((String)((Described)testAction).getDescription())) {
                this.debug("");
                this.debug(((Described)testAction).getDescription());
                this.debug("");
            }
        }
    }

    public void onTestActionFinish(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + " SUCCESS");
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + " SUCCESS");
            }
        }
    }

    public void onTestActionSkipped(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isIncremental()) {
                this.debug("SKIPPING TEST STEP " + (testCase.getActionIndex(testAction) + 1));
            } else {
                this.debug("SKIPPING TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount());
            }
            this.debug("TEST ACTION " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()) + " SKIPPED");
        }
    }

    public void onInboundMessage(Message message, TestContext context) {
        inboundMsgLogger.debug(message.toString());
    }

    public void onOutboundMessage(Message message, TestContext context) {
        outboundMsgLogger.debug(message.toString());
    }

    private void separator() {
        this.info("------------------------------------------------------------------------");
    }

    private void newLine() {
        this.info("");
    }

    protected void info(String line) {
        log.info(line);
    }

    protected void error(String line, Throwable cause) {
        log.error(line, cause);
    }

    protected void debug(String line) {
        if (this.isDebugEnabled()) {
            log.debug(line);
        }
    }

    protected boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }
}

