/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.script;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.script.TemplateBasedScriptBuilder;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class GroovyAction
extends AbstractTestAction {
    private final String script;
    private final String scriptResourcePath;
    private final String scriptTemplate;
    private final String scriptTemplatePath;
    private final boolean useScriptTemplate;
    private static Logger log = LoggerFactory.getLogger(GroovyAction.class);

    public GroovyAction(Builder builder) {
        super("groovy", builder);
        this.script = builder.script;
        this.scriptResourcePath = builder.scriptResourcePath;
        this.scriptTemplate = builder.scriptTemplate;
        this.scriptTemplatePath = builder.scriptTemplatePath;
        this.useScriptTemplate = builder.useScriptTemplate;
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            GroovyClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

                @Override
                public GroovyClassLoader run() {
                    ClassLoader parent = this.getClass().getClassLoader();
                    return new GroovyClassLoader(parent);
                }
            });
            this.assertScriptProvided();
            String rawCode = StringUtils.hasText((String)this.script) ? this.script.trim() : FileUtils.readToString(FileUtils.getFileResource(this.scriptResourcePath, context));
            String code = context.replaceDynamicContentInString(rawCode.trim());
            Class groovyClass = loader.parseClass(code);
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            if (this.useScriptTemplate && groovyObject.getClass().getSimpleName().startsWith("script")) {
                code = StringUtils.hasText((String)this.scriptTemplate) ? TemplateBasedScriptBuilder.fromTemplateScript(context.replaceDynamicContentInString(this.scriptTemplate)).withCode(code).build() : TemplateBasedScriptBuilder.fromTemplateResource(FileUtils.getFileResource(this.scriptTemplatePath, context)).withCode(code).build();
                groovyClass = loader.parseClass(code);
                groovyObject = (GroovyObject)groovyClass.newInstance();
            }
            if (log.isDebugEnabled()) {
                log.debug("Executing Groovy script:\n" + code);
            }
            if (groovyObject instanceof ScriptExecutor) {
                ((ScriptExecutor)groovyObject).execute(context);
            } else {
                groovyObject.invokeMethod("run", (Object)new Object[0]);
            }
            log.info("Groovy script execution successful");
        }
        catch (CitrusRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    private void assertScriptProvided() {
        if (!StringUtils.hasText((String)this.script) && this.scriptResourcePath == null) {
            throw new CitrusRuntimeException("Neither inline script nor external script resource is defined. Unable to execute groovy script.");
        }
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptResourcePath() {
        return this.scriptResourcePath;
    }

    public boolean isUseScriptTemplate() {
        return this.useScriptTemplate;
    }

    public String getScriptTemplatePath() {
        return this.scriptTemplatePath;
    }

    public String getScriptTemplate() {
        return this.scriptTemplate;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<GroovyAction, Builder> {
        private String script;
        private String scriptResourcePath;
        private String scriptTemplate;
        private String scriptTemplatePath = "classpath:com/consol/citrus/script/script-template.groovy";
        private boolean useScriptTemplate = true;

        public static Builder groovy(String script) {
            Builder builder = new Builder();
            builder.script(script);
            return builder;
        }

        public static Builder groovy(Resource scriptResource) {
            Builder builder = new Builder();
            builder.script(scriptResource);
            return builder;
        }

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder script(Resource scriptResource) {
            return this.script(scriptResource, FileUtils.getDefaultCharset());
        }

        public Builder script(Resource scriptResource, Charset charset) {
            try {
                this.script = FileUtils.readToString(scriptResource, charset);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
            }
            return this;
        }

        public Builder scriptResourcePath(String scriptResourcePath) {
            this.scriptResourcePath = scriptResourcePath;
            return this;
        }

        public Builder template(String scriptTemplatePath) {
            this.scriptTemplatePath = scriptTemplatePath;
            return this;
        }

        public Builder template(Resource scriptTemplate) {
            return this.template(scriptTemplate, FileUtils.getDefaultCharset());
        }

        public Builder template(Resource scriptTemplate, Charset charset) {
            try {
                this.scriptTemplate = FileUtils.readToString(scriptTemplate, charset);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read script template file", (Throwable)e);
            }
            return this;
        }

        public Builder skipTemplate() {
            return this.useScriptTemplate(false);
        }

        public Builder useScriptTemplate(boolean useScriptTemplate) {
            this.useScriptTemplate = useScriptTemplate;
            return this;
        }

        public GroovyAction build() {
            return new GroovyAction(this);
        }
    }

    public static interface ScriptExecutor {
        public void execute(TestContext var1);
    }
}

