/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.script;

import com.consol.citrus.TestCase;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public final class GroovyTestCaseParser
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static Logger log = LoggerFactory.getLogger(GroovyTestCaseParser.class);

    public TestCase parse(Resource groovyScript) {
        BufferedReader templateReader = null;
        BufferedReader bodyReader = null;
        try {
            String line;
            GroovyClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

                @Override
                public GroovyClassLoader run() {
                    ClassLoader parent = this.getClass().getClassLoader();
                    return new GroovyClassLoader(parent);
                }
            });
            StringBuilder script = new StringBuilder();
            bodyReader = new BufferedReader(new FileReader(groovyScript.getFile()));
            templateReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("test_template.groovy")));
            while ((line = templateReader.readLine()) != null) {
                String bodyLine;
                if (!line.trim().equalsIgnoreCase("\"+++++ BODY +++++\"")) {
                    script.append(line);
                    script.append("\n");
                    continue;
                }
                while ((bodyLine = bodyReader.readLine()) != null) {
                    script.append(bodyLine);
                    script.append("\n");
                }
            }
            Class groovyClass = loader.parseClass(script.toString());
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            if (groovyObject instanceof TestCaseBuilder) {
                TestCase testCase = ((TestCaseBuilder)groovyObject).build(this.applicationContext);
                return testCase;
            }
            try {
                throw new CitrusRuntimeException("Unable to parse groovy script. Script must implement TestCaseRunner.");
            }
            catch (InstantiationException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
            catch (CompilationFailedException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
        finally {
            try {
                if (templateReader != null) {
                    templateReader.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to close stream for groovy template resource", (Throwable)e);
            }
            try {
                if (bodyReader != null) {
                    bodyReader.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to close stream for groovy script resource", (Throwable)e);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public static interface TestCaseBuilder {
        public TestCase build(ApplicationContext var1);
    }
}

