/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.xml.XmlNamespaceAware;
import com.consol.citrus.variable.VariableExtractor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DelegatingPayloadVariableExtractor
implements VariableExtractor {
    private Map<String, String> pathExpressions;
    private Map<String, String> namespaces;
    private static final Logger LOG = LoggerFactory.getLogger(DelegatingPayloadVariableExtractor.class);

    public DelegatingPayloadVariableExtractor() {
        this(new Builder());
    }

    public DelegatingPayloadVariableExtractor(Builder builder) {
        this.pathExpressions = builder.expressions;
        this.namespaces = builder.namespaces;
    }

    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.pathExpressions)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading path elements.");
        }
        LinkedHashMap<String, String> jsonPathExpressions = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> xpathExpressions = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> pathExpression : this.pathExpressions.entrySet()) {
            String path = context.replaceDynamicContentInString(pathExpression.getKey());
            String variable = pathExpression.getValue();
            if (JsonPathMessageValidationContext.isJsonPathExpression(path)) {
                jsonPathExpressions.put(path, variable);
                continue;
            }
            xpathExpressions.put(path, variable);
        }
        if (!jsonPathExpressions.isEmpty()) {
            VariableExtractor.Builder jsonPathExtractor = (VariableExtractor.Builder)VariableExtractor.lookup((String)"jsonPath").orElseThrow(() -> new CitrusRuntimeException("Missing proper Json Path extractor implementation for resource 'jsonPath' - consider adding proper json validation module to the project"));
            jsonPathExtractor.expressions(jsonPathExpressions).build().extractVariables(message, context);
        }
        if (!xpathExpressions.isEmpty()) {
            VariableExtractor.Builder xpathExtractor = (VariableExtractor.Builder)VariableExtractor.lookup((String)"xpath").orElseThrow(() -> new CitrusRuntimeException("Missing proper Xpath extractor implementation for resource 'xpath' - consider adding proper xml validation module to the project"));
            if (!this.namespaces.isEmpty() && xpathExtractor instanceof XmlNamespaceAware) {
                ((XmlNamespaceAware)xpathExtractor).setNamespaces(this.namespaces);
            }
            xpathExtractor.expressions(xpathExpressions).build().extractVariables(message, context);
        }
    }

    public void setPathExpressions(Map<String, String> pathExpressions) {
        this.pathExpressions = pathExpressions;
    }

    public Map<String, String> getPathExpressions() {
        return this.pathExpressions;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public static final class Builder
    implements VariableExtractor.Builder<DelegatingPayloadVariableExtractor, Builder> {
        private final Map<String, String> expressions = new HashMap<String, String>();
        private final Map<String, String> namespaces = new HashMap<String, String>();

        public Builder namespaces(Map<String, String> namespaces) {
            this.namespaces.putAll(namespaces);
            return this;
        }

        public Builder namespace(String prefix, String namespace) {
            this.namespaces.put(prefix, namespace);
            return this;
        }

        public Builder expressions(Map<String, String> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String path, String variableName) {
            this.expressions.put(path, variableName);
            return this;
        }

        public DelegatingPayloadVariableExtractor build() {
            return new DelegatingPayloadVariableExtractor(this);
        }
    }
}

