/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.xml;

import com.consol.citrus.validation.context.DefaultValidationContext;
import com.consol.citrus.validation.context.SchemaValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.xml.XmlNamespaceAware;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.io.Resource;

public class XmlMessageValidationContext
extends DefaultValidationContext
implements SchemaValidationContext {
    private final Set<String> ignoreExpressions;
    private final Map<String, String> namespaces;
    private final Resource dtdResource;
    private final Map<String, String> controlNamespaces;
    private final boolean schemaValidation;
    private final String schemaRepository;
    private final String schema;

    public XmlMessageValidationContext() {
        this(new Builder());
    }

    public XmlMessageValidationContext(XmlValidationContextBuilder<?, ?> builder) {
        this.ignoreExpressions = ((XmlValidationContextBuilder)builder).ignoreExpressions;
        this.namespaces = ((XmlValidationContextBuilder)builder).namespaces;
        this.controlNamespaces = ((XmlValidationContextBuilder)builder).controlNamespaces;
        this.dtdResource = ((XmlValidationContextBuilder)builder).dtdResource;
        this.schemaValidation = ((XmlValidationContextBuilder)builder).schemaValidation;
        this.schemaRepository = ((XmlValidationContextBuilder)builder).schemaRepository;
        this.schema = ((XmlValidationContextBuilder)builder).schema;
    }

    public Set<String> getIgnoreExpressions() {
        return this.ignoreExpressions;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Resource getDTDResource() {
        return this.dtdResource;
    }

    public Map<String, String> getControlNamespaces() {
        return this.controlNamespaces;
    }

    public boolean isSchemaValidationEnabled() {
        return this.schemaValidation;
    }

    public String getSchemaRepository() {
        return this.schemaRepository;
    }

    public String getSchema() {
        return this.schema;
    }

    public static abstract class XmlValidationContextBuilder<T extends XmlMessageValidationContext, S extends XmlValidationContextBuilder<T, S>>
    implements ValidationContext.Builder<T, XmlValidationContextBuilder<T, S>>,
    XmlNamespaceAware,
    SchemaValidationContext.Builder<XmlValidationContextBuilder<T, S>> {
        protected final S self;
        private Set<String> ignoreExpressions = new HashSet<String>();
        private Map<String, String> namespaces = new HashMap<String, String>();
        private Resource dtdResource;
        private Map<String, String> controlNamespaces = new HashMap<String, String>();
        private boolean schemaValidation = true;
        private String schemaRepository;
        private String schema;

        protected XmlValidationContextBuilder() {
            this.self = this;
        }

        public S schemaValidation(boolean enabled) {
            this.schemaValidation = enabled;
            return this.self;
        }

        public S namespace(String prefix, String namespaceUri) {
            this.controlNamespaces.put(prefix, namespaceUri);
            return this.self;
        }

        public S namespaces(Map<String, String> namespaces) {
            this.controlNamespaces.putAll(namespaces);
            return this.self;
        }

        public S namespaceContext(String prefix, String namespaceUri) {
            this.namespaces.put(prefix, namespaceUri);
            return this.self;
        }

        public S namespaceContext(Map<String, String> namespaces) {
            this.namespaces.putAll(namespaces);
            return this.self;
        }

        public S schema(String schemaName) {
            this.schema = schemaName;
            return this.self;
        }

        public S schemaRepository(String schemaRepository) {
            this.schemaRepository = schemaRepository;
            return this.self;
        }

        public S dtd(Resource dtdResource) {
            this.dtdResource = dtdResource;
            return this.self;
        }

        public S ignore(String path) {
            this.ignoreExpressions.add(path);
            return this.self;
        }

        public S ignore(Set<String> paths) {
            this.ignoreExpressions.addAll(paths);
            return this.self;
        }

        public void setNamespaces(Map<String, String> namespaces) {
            this.namespaces = namespaces;
        }
    }

    public static final class Builder
    extends XmlValidationContextBuilder<XmlMessageValidationContext, Builder> {
        public static Builder xml() {
            return new Builder();
        }

        public XmlMessageValidationContext build() {
            return new XmlMessageValidationContext(this);
        }
    }
}

