/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.message.Message;
import com.consol.citrus.variable.VariableExtractor;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class MessageHeaderVariableExtractor
implements VariableExtractor {
    private final Map<String, String> headerMappings;

    public MessageHeaderVariableExtractor() {
        this(new Builder());
    }

    private MessageHeaderVariableExtractor(Builder builder) {
        this.headerMappings = builder.expressions;
    }

    public void extractVariables(Message message, TestContext context) {
        if (CollectionUtils.isEmpty(this.headerMappings)) {
            return;
        }
        for (Map.Entry<String, String> entry : this.headerMappings.entrySet()) {
            String headerElementName = entry.getKey();
            String targetVariableName = entry.getValue();
            if (message.getHeader(headerElementName) == null) {
                throw new UnknownElementException("Could not find header element " + headerElementName + " in received header");
            }
            context.setVariable(targetVariableName, (Object)message.getHeader(headerElementName).toString());
        }
    }

    public Map<String, String> getHeaderMappings() {
        return this.headerMappings;
    }

    public static final class Builder
    implements VariableExtractor.Builder<MessageHeaderVariableExtractor, Builder> {
        private final Map<String, String> expressions = new HashMap<String, String>();

        public Builder headers(Map<String, String> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder header(String headerName, String variableName) {
            this.expressions.put(headerName, variableName);
            return this;
        }

        public Builder expressions(Map<String, String> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String headerName, String variableName) {
            this.expressions.put(headerName, variableName);
            return this;
        }

        public MessageHeaderVariableExtractor build() {
            return new MessageHeaderVariableExtractor(this);
        }
    }
}

