/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.CitrusVersion;
import com.consol.citrus.TestAction;
import com.consol.citrus.container.AfterSuite;
import com.consol.citrus.container.BeforeSuite;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.report.MessageListener;
import com.consol.citrus.report.MessageListenerAware;
import com.consol.citrus.report.TestListener;
import com.consol.citrus.report.TestListenerAware;
import com.consol.citrus.report.TestReporter;
import com.consol.citrus.report.TestReporterAware;
import com.consol.citrus.report.TestSuiteListener;
import com.consol.citrus.report.TestSuiteListenerAware;

public final class Citrus
implements TestListenerAware,
TestSuiteListenerAware,
TestReporterAware,
MessageListenerAware {
    private final CitrusContext citrusContext;

    Citrus(CitrusContext citrusContext) {
        this.citrusContext = citrusContext;
    }

    public static Citrus newInstance() {
        return CitrusInstanceManager.newInstance();
    }

    public static Citrus newInstance(CitrusContext citrusContext) {
        return CitrusInstanceManager.newInstance(citrusContext);
    }

    public void beforeSuite(String suiteName, String ... testGroups) {
        this.citrusContext.getTestSuiteListeners().onStart();
        for (BeforeSuite sequenceBeforeSuite : this.citrusContext.getBeforeSuite()) {
            try {
                if (!sequenceBeforeSuite.shouldExecute(suiteName, testGroups)) continue;
                sequenceBeforeSuite.execute(this.citrusContext.createTestContext());
            }
            catch (Exception e) {
                this.citrusContext.getTestSuiteListeners().onStartFailure((Throwable)e);
                this.afterSuite(suiteName, testGroups);
                throw new AssertionError("Before suite failed with errors", e);
            }
        }
        this.citrusContext.getTestSuiteListeners().onStartSuccess();
    }

    public void afterSuite(String suiteName, String ... testGroups) {
        this.citrusContext.getTestSuiteListeners().onFinish();
        for (AfterSuite sequenceAfterSuite : this.citrusContext.getAfterSuite()) {
            try {
                if (!sequenceAfterSuite.shouldExecute(suiteName, testGroups)) continue;
                sequenceAfterSuite.execute(this.citrusContext.createTestContext());
            }
            catch (Exception e) {
                this.citrusContext.getTestSuiteListeners().onFinishFailure((Throwable)e);
                throw new AssertionError("After suite failed with errors", e);
            }
        }
        this.citrusContext.getTestSuiteListeners().onFinishSuccess();
    }

    public void run(TestAction action) {
        this.run(action, this.citrusContext.createTestContext());
    }

    public void run(TestAction action, TestContext testContext) {
        action.execute(testContext);
    }

    public static String getVersion() {
        return CitrusVersion.version();
    }

    public void addTestSuiteListener(TestSuiteListener suiteListener) {
        this.citrusContext.addTestSuiteListener(suiteListener);
    }

    public void addTestListener(TestListener testListener) {
        this.citrusContext.addTestListener(testListener);
    }

    public void addTestReporter(TestReporter testReporter) {
        this.citrusContext.addTestReporter(testReporter);
    }

    public void addMessageListener(MessageListener listener) {
        this.citrusContext.addMessageListener(listener);
    }

    public CitrusContext getCitrusContext() {
        return this.citrusContext;
    }

    public void close() {
        this.citrusContext.close();
    }
}

