/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceVariablesAction
extends AbstractTestAction {
    private final List<String> variableNames;
    private static Logger log = LoggerFactory.getLogger(TraceVariablesAction.class);

    public TraceVariablesAction(Builder builder) {
        super("trace", builder);
        this.variableNames = builder.variableNames;
    }

    @Override
    public void doExecute(TestContext context) {
        log.info("Trace variables");
        Iterator<Object> it = this.variableNames != null && this.variableNames.size() > 0 ? this.variableNames.iterator() : context.getVariables().keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = context.getVariable(key);
            log.info("Variable " + key + " = " + value);
        }
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<TraceVariablesAction, Builder> {
        private List<String> variableNames = new ArrayList<String>();

        public static Builder traceVariables() {
            return new Builder();
        }

        public static Builder traceVariables(String ... variableNames) {
            Builder builder = new Builder();
            builder.variables(variableNames);
            return builder;
        }

        public static Builder traceVariables(String variable) {
            Builder builder = new Builder();
            builder.variable(variable);
            return builder;
        }

        public Builder variable(String variable) {
            this.variableNames.add(variable);
            return this;
        }

        public Builder variables(String ... variables) {
            Stream.of(variables).forEach(this::variable);
            return this;
        }

        public TraceVariablesAction build() {
            return new TraceVariablesAction(this);
        }
    }
}

