/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ParallelContainerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parallel
extends AbstractActionContainer {
    private Stack<Thread> threads = new Stack();
    private List<CitrusRuntimeException> exceptions = new ArrayList<CitrusRuntimeException>();
    private static Logger log = LoggerFactory.getLogger(Parallel.class);

    public Parallel(Builder builder) {
        super("parallel", builder);
    }

    @Override
    public void doExecute(TestContext context) {
        for (TestActionBuilder actionBuilder : this.actions) {
            final TestAction action = actionBuilder.build();
            Thread t = new Thread(new ActionRunner(action, context){

                @Override
                public void exceptionCallback(CitrusRuntimeException e) {
                    if (Parallel.this.exceptions.isEmpty()) {
                        Parallel.this.setActiveAction(action);
                    }
                    Parallel.this.exceptions.add(e);
                }
            });
            this.threads.push(t);
            t.start();
        }
        while (!this.threads.isEmpty()) {
            try {
                this.threads.pop().join();
            }
            catch (InterruptedException e) {
                log.error("Unable to join thread", (Throwable)e);
            }
        }
        if (!this.exceptions.isEmpty()) {
            if (this.exceptions.size() == 1) {
                throw this.exceptions.get(0);
            }
            throw new ParallelContainerException(this.exceptions);
        }
    }

    public static class Builder
    extends AbstractTestContainerBuilder<Parallel, Builder> {
        public static Builder parallel() {
            return new Builder();
        }

        @Override
        public Parallel doBuild() {
            return new Parallel(this);
        }
    }

    private static abstract class ActionRunner
    implements Runnable {
        private final TestAction action;
        private final TestContext context;

        public ActionRunner(TestAction action, TestContext context) {
            this.action = action;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.action.execute(this.context);
            }
            catch (CitrusRuntimeException e) {
                log.error("Parallel test action raised error", (Throwable)e);
                this.exceptionCallback(e);
            }
            catch (AssertionError | Exception e) {
                log.error("Parallel test action raised error", (Throwable)e);
                this.exceptionCallback(new CitrusRuntimeException((Throwable)e));
            }
        }

        public abstract void exceptionCallback(CitrusRuntimeException var1);
    }
}

