/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint.direct;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointAdapter;
import com.consol.citrus.endpoint.direct.DirectEndpoint;
import com.consol.citrus.endpoint.direct.DirectSyncEndpoint;
import com.consol.citrus.endpoint.direct.DirectSyncEndpointConfiguration;
import com.consol.citrus.endpoint.direct.DirectSyncProducer;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectEndpointAdapter
extends AbstractEndpointAdapter {
    private DirectSyncEndpoint endpoint;
    private DirectSyncProducer producer;
    private final DirectSyncEndpointConfiguration endpointConfiguration;
    private static Logger log = LoggerFactory.getLogger(DirectEndpointAdapter.class);

    public DirectEndpointAdapter(DirectSyncEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        this.endpoint = new DirectSyncEndpoint(endpointConfiguration);
        this.endpoint.setName(this.getName());
        this.producer = new DirectSyncProducer(this.endpoint.getProducerName(), endpointConfiguration);
    }

    @Override
    public Message handleMessageInternal(Message request) {
        log.debug("Forwarding request to message queue ...");
        TestContext context = this.getTestContext();
        Message replyMessage = null;
        try {
            this.producer.send(request, context);
            replyMessage = this.endpointConfiguration.getCorrelator() != null ? this.producer.receive(this.endpointConfiguration.getCorrelator().getCorrelationKey(request), context, this.endpointConfiguration.getTimeout()) : this.producer.receive(context, this.endpointConfiguration.getTimeout());
        }
        catch (ActionTimeoutException e) {
            log.warn(e.getMessage());
        }
        return replyMessage;
    }

    public DirectEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DirectSyncEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }
}

