/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint.direct;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.direct.DirectProducer;
import com.consol.citrus.endpoint.direct.DirectSyncEndpointConfiguration;
import com.consol.citrus.exceptions.MessageTimeoutException;
import com.consol.citrus.exceptions.ReplyMessageTimeoutException;
import com.consol.citrus.message.DefaultMessageQueue;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageQueue;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.ReplyConsumer;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectSyncProducer
extends DirectProducer
implements ReplyConsumer {
    private static Logger log = LoggerFactory.getLogger(DirectSyncProducer.class);
    private CorrelationManager<Message> correlationManager;
    private final DirectSyncEndpointConfiguration endpointConfiguration;

    public DirectSyncProducer(String name, DirectSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager<Message>(endpointConfiguration, "Reply message did not arrive yet");
    }

    @Override
    public void send(Message message, TestContext context) {
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        String destinationQueueName = this.getDestinationQueueName();
        if (log.isDebugEnabled()) {
            log.debug("Sending message to queue: '" + destinationQueueName + "'");
            log.debug("Message to send is:\n" + message.toString());
        }
        log.info("Message was sent to queue: '" + destinationQueueName + "'");
        MessageQueue replyQueue = this.getReplyQueue(message, context);
        this.getDestinationQueue(context).send(message);
        Message replyMessage = replyQueue.receive(this.endpointConfiguration.getTimeout());
        if (replyMessage == null) {
            throw new ReplyMessageTimeoutException(this.endpointConfiguration.getTimeout(), destinationQueueName);
        }
        log.info("Received synchronous response from reply queue");
        this.correlationManager.store(correlationKey, (Object)replyMessage);
    }

    private MessageQueue getReplyQueue(Message message, TestContext context) {
        if (message.getHeader("citrus_reply_queue") == null) {
            DefaultMessageQueue temporaryQueue = new DefaultMessageQueue(this.getName() + "." + UUID.randomUUID().toString());
            message.setHeader("citrus_reply_queue", (Object)temporaryQueue);
            return temporaryQueue;
        }
        if (message.getHeader("citrus_reply_queue") instanceof MessageQueue) {
            return (MessageQueue)message.getHeader("citrus_reply_queue");
        }
        return this.resolveQueueName(message.getHeader("citrus_reply_queue").toString(), context);
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.endpointConfiguration.getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        if (message == null) {
            throw new MessageTimeoutException(timeout, this.getDestinationQueueName());
        }
        return message;
    }

    public CorrelationManager<Message> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

