/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.selector;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageSelector;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;

public abstract class AbstractMessageSelector
implements MessageSelector {
    protected final String selectKey;
    protected final String matchingValue;
    protected final TestContext context;

    public AbstractMessageSelector(String selectKey, String matchingValue, TestContext context) {
        this.selectKey = selectKey;
        this.matchingValue = matchingValue;
        this.context = context;
    }

    String getPayloadAsString(Message message) {
        if (message.getPayload() instanceof Message) {
            return (String)((Message)message.getPayload()).getPayload(String.class);
        }
        return message.getPayload().toString();
    }

    protected boolean evaluate(String value) {
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)this.matchingValue)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher((String)this.selectKey, (String)value, (String)this.matchingValue, (TestContext)this.context);
                return true;
            }
            catch (ValidationException e) {
                return false;
            }
        }
        return value.equals(this.matchingValue);
    }
}

