/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.ValueMatcher;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class ValidationUtils {
    private static final Map<String, ValueMatcher> DEFAULT_VALUE_MATCHERS = ValueMatcher.lookup();

    private ValidationUtils() {
    }

    public static void validateValues(Object actualValue, Object expectedValue, String pathExpression, TestContext context) throws ValidationException {
        block21: {
            try {
                if (actualValue != null) {
                    Assert.isTrue((expectedValue != null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", null, actualValue));
                    Optional<ValueMatcher> matcher = ValidationUtils.getValueMatcher(expectedValue, context);
                    if (matcher.isPresent()) {
                        Assert.isTrue((boolean)matcher.get().validate(actualValue, expectedValue, context), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not matching for element '" + pathExpression + "'", expectedValue, actualValue));
                        return;
                    }
                    if (!(expectedValue instanceof String)) {
                        Object converted = context.getTypeConverter().convertIfNecessary(actualValue, expectedValue.getClass());
                        if (converted == null) {
                            throw new CitrusRuntimeException(String.format("Failed to convert value '%s' to required type '%s'", actualValue, expectedValue.getClass()));
                        }
                        if (converted instanceof List) {
                            Assert.isTrue((boolean)converted.toString().equals(expectedValue.toString()), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue.toString(), converted.toString()));
                        } else if (converted instanceof String[]) {
                            String convertedDelimitedString = StringUtils.arrayToCommaDelimitedString((Object[])((String[])converted));
                            String expectedDelimitedString = StringUtils.arrayToCommaDelimitedString((Object[])((String[])expectedValue));
                            Assert.isTrue((boolean)convertedDelimitedString.equals(expectedDelimitedString), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedDelimitedString, convertedDelimitedString));
                        } else if (converted instanceof byte[]) {
                            String convertedBase64 = Base64.encodeBase64String((byte[])((byte[])converted));
                            String expectedBase64 = Base64.encodeBase64String((byte[])((byte[])expectedValue));
                            Assert.isTrue((boolean)convertedBase64.equals(expectedBase64), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedBase64, convertedBase64));
                        } else {
                            Assert.isTrue((boolean)converted.equals(expectedValue), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue, converted));
                        }
                    } else {
                        String actualValueString;
                        String expectedValueString = expectedValue.toString();
                        if (List.class.isAssignableFrom(actualValue.getClass())) {
                            actualValueString = StringUtils.arrayToCommaDelimitedString((Object[])((List)actualValue).toArray(new Object[((List)actualValue).size()]));
                            expectedValueString = expectedValueString.replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
                        } else {
                            actualValueString = actualValue.toString();
                        }
                        if (ValidationMatcherUtils.isValidationMatcherExpression((String)String.valueOf(expectedValueString))) {
                            ValidationMatcherUtils.resolveValidationMatcher((String)pathExpression, (String)actualValueString, (String)String.valueOf(expectedValueString), (TestContext)context);
                        } else {
                            Assert.isTrue((boolean)actualValueString.equals(expectedValueString), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValueString, actualValueString));
                        }
                    }
                    break block21;
                }
                if (expectedValue == null) break block21;
                Optional<ValueMatcher> matcher = ValidationUtils.getValueMatcher(expectedValue, context);
                if (matcher.isPresent()) {
                    Assert.isTrue((boolean)matcher.get().validate(actualValue, expectedValue, context), (String)ValidationUtils.buildValueMismatchErrorMessage("Values not matching for element '" + pathExpression + "'", expectedValue, null));
                    break block21;
                }
                if (expectedValue instanceof String) {
                    String expectedValueString = expectedValue.toString();
                    if (ValidationMatcherUtils.isValidationMatcherExpression((String)expectedValueString)) {
                        ValidationMatcherUtils.resolveValidationMatcher((String)pathExpression, null, (String)expectedValueString, (TestContext)context);
                    } else {
                        Assert.isTrue((!StringUtils.hasText((String)expectedValueString) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValueString, null));
                    }
                    break block21;
                }
                throw new ValidationException("Validation failed: " + ValidationUtils.buildValueMismatchErrorMessage("Values not equal for element '" + pathExpression + "'", expectedValue, null));
            }
            catch (AssertionError | IllegalArgumentException e) {
                throw new ValidationException("Validation failed:", (Throwable)e);
            }
        }
    }

    private static Optional<ValueMatcher> getValueMatcher(Object expectedValue, TestContext context) {
        HashMap<String, ValueMatcher> allMatchers = new HashMap<String, ValueMatcher>(DEFAULT_VALUE_MATCHERS);
        allMatchers.putAll(context.getReferenceResolver().resolveAll(ValueMatcher.class));
        return allMatchers.values().stream().filter(matcher -> matcher.supports(expectedValue.getClass())).findFirst();
    }

    public static String buildValueMismatchErrorMessage(String baseMessage, Object controlValue, Object actualValue) {
        return baseMessage + ", expected '" + controlValue + "' but was '" + actualValue + "'";
    }
}

