/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.annotations;

import com.consol.citrus.Citrus;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusEndpointAnnotations;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class CitrusAnnotations {
    private static Logger log = LoggerFactory.getLogger(CitrusAnnotations.class);

    private CitrusAnnotations() {
    }

    public static void injectAll(Object target) {
        CitrusAnnotations.injectAll(target, Citrus.newInstance());
    }

    public static void injectAll(Object target, Citrus citrusFramework) {
        CitrusAnnotations.injectAll(target, citrusFramework, citrusFramework.getCitrusContext().createTestContext());
    }

    public static void injectAll(Object target, Citrus citrusFramework, TestContext context) {
        CitrusAnnotations.injectCitrusFramework(target, citrusFramework);
        citrusFramework.getCitrusContext().parseConfiguration(target);
        CitrusAnnotations.injectEndpoints(target, context);
        CitrusAnnotations.injectTestContext(target, context);
    }

    public static void injectEndpoints(Object target, TestContext context) {
        CitrusEndpointAnnotations.injectEndpoints((Object)target, (TestContext)context);
    }

    public static void injectCitrusFramework(final Object testCase, final Citrus citrusFramework) {
        ReflectionUtils.doWithFields(testCase.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                log.trace(String.format("Injecting Citrus framework instance on test class field '%s'", field.getName()));
                ReflectionUtils.setField((Field)field, (Object)testCase, (Object)citrusFramework);
            }
        }, (ReflectionUtils.FieldFilter)new ReflectionUtils.FieldFilter(){

            public boolean matches(Field field) {
                if (field.isAnnotationPresent(CitrusFramework.class) && Citrus.class.isAssignableFrom(field.getType())) {
                    if (!field.isAccessible()) {
                        ReflectionUtils.makeAccessible((Field)field);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static void injectTestContext(Object target, TestContext context) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestContext.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            log.trace(String.format("Injecting test context instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)context);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestContext.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    public static void injectTestRunner(Object target, TestCaseRunner runner) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestCaseRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            log.trace(String.format("Injecting test runner instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)runner);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestCaseRunner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
        CitrusAnnotations.injectTestActionRunner(target, (TestActionRunner)runner);
        CitrusAnnotations.injectGherkinTestActionRunner(target, (GherkinTestActionRunner)runner);
    }

    private static void injectTestActionRunner(Object target, TestActionRunner runner) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestActionRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            log.trace(String.format("Injecting test action runner instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)runner);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestActionRunner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    private static void injectGherkinTestActionRunner(Object target, GherkinTestActionRunner runner) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!GherkinTestActionRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            log.trace(String.format("Injecting test action runner instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)runner);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && GherkinTestActionRunner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }
}

