/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.container.AbstractActionContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractTestBoundaryActionContainer
extends AbstractActionContainer {
    private String namePattern;
    private String packageNamePattern;
    private List<String> testGroups = new ArrayList<String>();
    private Map<String, String> env = new HashMap<String, String>();
    private Map<String, String> systemProperties = new HashMap<String, String>();

    public boolean shouldExecute(String testName, String packageName, String[] includedGroups) {
        String baseErrorMessage = "Skip before test container because of %s restrictions - do not execute container '%s'";
        if (StringUtils.hasText((String)this.packageNamePattern) && !PatternMatchUtils.simpleMatch((String)this.packageNamePattern, (String)packageName)) {
            this.log.warn(String.format(baseErrorMessage, "test package", this.getName()));
            return false;
        }
        if (StringUtils.hasText((String)this.namePattern) && !PatternMatchUtils.simpleMatch((String)this.namePattern, (String)testName)) {
            this.log.warn(String.format(baseErrorMessage, "test name", this.getName()));
            return false;
        }
        if (!this.checkTestGroups(includedGroups)) {
            this.log.warn(String.format(baseErrorMessage, "test groups", this.getName()));
            return false;
        }
        for (Map.Entry<String, String> envEntry : this.env.entrySet()) {
            if (System.getenv().containsKey(envEntry.getKey()) && (!StringUtils.hasText((String)envEntry.getValue()) || System.getenv().get(envEntry.getKey()).equals(envEntry.getValue()))) continue;
            this.log.warn(String.format(baseErrorMessage, "env properties", this.getName()));
            return false;
        }
        for (Map.Entry<String, String> systemProperty : this.systemProperties.entrySet()) {
            if (System.getProperties().containsKey(systemProperty.getKey()) && (!StringUtils.hasText((String)systemProperty.getValue()) || System.getProperties().get(systemProperty.getKey()).equals(systemProperty.getValue()))) continue;
            this.log.warn(String.format(baseErrorMessage, "system properties", this.getName()));
            return false;
        }
        return true;
    }

    private boolean checkTestGroups(String[] includedGroups) {
        if (this.testGroups.isEmpty()) {
            return true;
        }
        if (includedGroups != null) {
            for (String includedGroup : includedGroups) {
                if (!this.testGroups.contains(includedGroup)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTestGroups() {
        return this.testGroups;
    }

    public void setTestGroups(List<String> testGroups) {
        this.testGroups = testGroups;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(String namePattern) {
        this.namePattern = namePattern;
    }

    public String getPackageNamePattern() {
        return this.packageNamePattern;
    }

    public void setPackageNamePattern(String packageNamePattern) {
        this.packageNamePattern = packageNamePattern;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }
}

