/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint.adapter;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.adapter.StaticEndpointAdapter;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class StaticResponseEndpointAdapter
extends StaticEndpointAdapter {
    private String messagePayload = "";
    private String messagePayloadResource;
    private String messagePayloadResourceCharset = CitrusSettings.CITRUS_FILE_ENCODING;
    private Map<String, Object> messageHeader = new HashMap<String, Object>();

    @Override
    public Message handleMessageInternal(Message request) {
        String payload;
        TestContext context = this.getTestContext();
        context.getMessageStore().storeMessage("request", request);
        if (StringUtils.hasText((String)this.messagePayloadResource)) {
            try {
                payload = context.replaceDynamicContentInString(FileUtils.readToString(new PathMatchingResourcePatternResolver().getResource(this.messagePayloadResource), Charset.forName(context.replaceDynamicContentInString(this.messagePayloadResourceCharset))));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read message payload file resource", (Throwable)e);
            }
        } else {
            payload = context.replaceDynamicContentInString(this.messagePayload);
        }
        return new DefaultMessage(payload, context.resolveDynamicValuesInMap(this.messageHeader));
    }

    public String getMessagePayload() {
        return this.messagePayload;
    }

    public void setMessagePayload(String messagePayload) {
        this.messagePayload = messagePayload;
    }

    public String getMessagePayloadResource() {
        return this.messagePayloadResource;
    }

    public void setMessagePayloadResource(String messagePayloadResource) {
        this.messagePayloadResource = messagePayloadResource;
    }

    public String getMessagePayloadResourceCharset() {
        return this.messagePayloadResourceCharset;
    }

    public void setMessagePayloadResourceCharset(String messagePayloadResourceCharset) {
        this.messagePayloadResourceCharset = messagePayloadResourceCharset;
    }

    public Map<String, Object> getMessageHeader() {
        return this.messageHeader;
    }

    public void setMessageHeader(Map<String, Object> messageHeader) {
        this.messageHeader = messageHeader;
    }
}

