/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.selector;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageSelector;
import com.consol.citrus.message.selector.AbstractMessageSelector;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HeaderMatchingMessageSelector
extends AbstractMessageSelector {
    public static final String SELECTOR_PREFIX = "header:";

    public HeaderMatchingMessageSelector(String selectKey, String matchingValue, TestContext context) {
        super(selectKey, matchingValue, context);
    }

    public boolean accept(Message message) {
        Map messageHeaders = message.getHeaders();
        HashMap<String, Object> nestedMessageHeaders = new HashMap();
        if (message.getPayload() instanceof Message) {
            nestedMessageHeaders = ((Message)message.getPayload()).getHeaders();
        }
        if (nestedMessageHeaders.containsKey(this.selectKey)) {
            return this.matchHeader(nestedMessageHeaders);
        }
        if (messageHeaders.containsKey(this.selectKey)) {
            return this.matchHeader(messageHeaders);
        }
        return false;
    }

    private boolean matchHeader(Map<String, Object> messageHeaders) {
        return Optional.ofNullable(messageHeaders.get(this.selectKey)).map(Object::toString).map(this::evaluate).orElse(false);
    }

    public static class Factory
    implements MessageSelector.MessageSelectorFactory {
        public boolean supports(String key) {
            return key.startsWith(HeaderMatchingMessageSelector.SELECTOR_PREFIX);
        }

        public HeaderMatchingMessageSelector create(String key, String value, TestContext context) {
            if (key.startsWith(HeaderMatchingMessageSelector.SELECTOR_PREFIX)) {
                return new HeaderMatchingMessageSelector(key.substring(HeaderMatchingMessageSelector.SELECTOR_PREFIX.length()), value, context);
            }
            return new HeaderMatchingMessageSelector(key, value, context);
        }
    }
}

