/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.interceptor;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.AbstractMessageProcessor;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class BinaryMessageProcessor
extends AbstractMessageProcessor {
    private final Charset encoding;

    public BinaryMessageProcessor() {
        this(Builder.toBinary());
    }

    public BinaryMessageProcessor(Builder builder) {
        this.encoding = builder.encoding;
    }

    protected void processMessage(Message message, TestContext context) {
        if (message.getPayload() instanceof String) {
            message.setPayload((Object)((String)message.getPayload(String.class)).getBytes(this.encoding));
        } else if (message.getPayload() instanceof Resource) {
            try {
                message.setPayload((Object)FileCopyUtils.copyToByteArray((InputStream)((Resource)message.getPayload(Resource.class)).getInputStream()));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to build binary message payload from payload resource", (Throwable)e);
            }
        } else {
            message.setPayload(message.getPayload(byte[].class));
        }
        message.setType(MessageType.BINARY.name());
    }

    public static final class Builder
    implements MessageProcessor.Builder<BinaryMessageProcessor, Builder> {
        private Charset encoding = Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING);

        public static Builder toBinary() {
            return new Builder();
        }

        public Builder encoding(String charsetName) {
            return this.encoding(Charset.forName(charsetName));
        }

        public Builder encoding(Charset encoding) {
            this.encoding = encoding;
            return this;
        }

        public BinaryMessageProcessor build() {
            return new BinaryMessageProcessor(this);
        }
    }
}

