/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.CitrusContext;
import com.consol.citrus.DefaultCitrusContextProvider;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface CitrusContextProvider {
    public static final Logger LOG = LoggerFactory.getLogger(CitrusContextProvider.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/context/provider";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/context/provider");

    public CitrusContext create();

    public static CitrusContextProvider lookup() {
        Map provider = TYPE_RESOLVER.resolveAll("", "*");
        if (provider.isEmpty()) {
            LOG.debug("Using default Citrus context provider");
            return new DefaultCitrusContextProvider();
        }
        if (provider.size() > 1) {
            LOG.warn(String.format("Found %d Citrus context provider implementations. Please choose one of them.", provider.size()));
        }
        if (LOG.isDebugEnabled()) {
            provider.forEach((k, v) -> LOG.debug(String.format("Found Citrus context provider '%s' as %s", k, v.getClass())));
        }
        CitrusContextProvider contextProvider = (CitrusContextProvider)provider.values().iterator().next();
        LOG.debug(String.format("Using Citrus context provider '%s' as %s", provider.keySet().iterator().next(), contextProvider));
        return contextProvider;
    }

    public static Optional<CitrusContextProvider> lookup(String name) {
        try {
            CitrusContextProvider instance = (CitrusContextProvider)TYPE_RESOLVER.resolve(name, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve Citrus context provider from resource '%s/%s'", RESOURCE_PATH, name));
            return Optional.empty();
        }
    }
}

