/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.Completable;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.context.TestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActionContainer
extends AbstractTestAction
implements TestActionContainer,
Completable {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected List<TestActionBuilder<?>> actions = new ArrayList();
    private List<TestAction> executedActions = new ArrayList<TestAction>();
    private TestAction activeAction;

    public AbstractActionContainer() {
    }

    public AbstractActionContainer(String name, AbstractTestContainerBuilder<?, ?> builder) {
        super(name, builder);
        this.actions = builder.getActions();
    }

    public AbstractActionContainer setActions(List<TestAction> actions) {
        this.actions = actions.stream().map(action -> () -> action).collect(Collectors.toList());
        return this;
    }

    public AbstractActionContainer addTestActions(TestAction ... toAdd) {
        this.actions.addAll(Stream.of(toAdd).map(action -> () -> action).collect(Collectors.toList()));
        return this;
    }

    public AbstractActionContainer addTestActions(TestActionBuilder<?> ... toAdd) {
        this.actions.addAll(Arrays.asList(toAdd));
        return this;
    }

    public boolean isDone(TestContext context) {
        if (this.isDisabled(context)) {
            return true;
        }
        for (TestAction action : this.executedActions) {
            if (!(action instanceof Completable) || ((Completable)action).isDone(context)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug(Optional.ofNullable(action.getName()).filter(name -> name.trim().length() > 0).orElse(action.getClass().getName()) + " not completed yet");
            }
            return false;
        }
        return true;
    }

    public List<TestAction> getActions() {
        return this.actions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public long getActionCount() {
        return this.actions.size();
    }

    public AbstractActionContainer addTestAction(TestAction action) {
        this.actions.add(() -> action);
        return this;
    }

    public AbstractActionContainer addTestAction(TestActionBuilder<?> action) {
        this.actions.add(action);
        return this;
    }

    public int getActionIndex(TestAction action) {
        return this.executedActions.indexOf(action);
    }

    public TestAction getActiveAction() {
        return this.activeAction;
    }

    public void setActiveAction(TestAction action) {
        this.activeAction = action;
        this.executedActions.add(action);
    }

    public List<TestAction> getExecutedActions() {
        return this.executedActions;
    }

    public TestAction getTestAction(int index) {
        if (index < this.executedActions.size()) {
            return this.executedActions.get(index);
        }
        return this.actions.get(index).build();
    }
}

