/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.condition.ActionCondition;
import com.consol.citrus.condition.Condition;
import com.consol.citrus.condition.FileCondition;
import com.consol.citrus.condition.HttpCondition;
import com.consol.citrus.condition.MessageCondition;
import com.consol.citrus.container.WaitActionConditionBuilder;
import com.consol.citrus.container.WaitConditionBuilder;
import com.consol.citrus.container.WaitFileConditionBuilder;
import com.consol.citrus.container.WaitHttpConditionBuilder;
import com.consol.citrus.container.WaitMessageConditionBuilder;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wait
extends AbstractTestAction {
    private static final Logger log = LoggerFactory.getLogger(Wait.class);
    private final Condition condition;
    private final String time;
    private final String interval;

    public Wait(Builder builder) {
        super("wait", builder);
        this.condition = builder.condition;
        this.time = builder.time;
        this.interval = builder.interval;
    }

    @Override
    public void doExecute(TestContext context) {
        Boolean conditionSatisfied = null;
        long timeLeft = this.getWaitTimeMs(context);
        long intervalMs = this.getIntervalMs(context);
        if (intervalMs > timeLeft) {
            intervalMs = timeLeft;
        }
        Callable<Boolean> callable = () -> this.condition.isSatisfied(context);
        while (timeLeft > 0L) {
            timeLeft -= intervalMs;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Waiting for condition %s", this.condition.getName()));
            }
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Boolean> future = executor.submit(callable);
            long checkStartTime = System.currentTimeMillis();
            try {
                conditionSatisfied = future.get(intervalMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn(String.format("Condition check interrupted with '%s'", e.getClass().getSimpleName()));
            }
            executor.shutdown();
            if (Boolean.TRUE.equals(conditionSatisfied)) {
                log.info(this.condition.getSuccessMessage(context));
                return;
            }
            long sleepTime = intervalMs - (System.currentTimeMillis() - checkStartTime);
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted during wait!", (Throwable)e);
            }
        }
        throw new CitrusRuntimeException(this.condition.getErrorMessage(context));
    }

    private long getWaitTimeMs(TestContext context) {
        return Long.parseLong(context.replaceDynamicContentInString(this.time));
    }

    private long getIntervalMs(TestContext context) {
        return Long.parseLong(context.replaceDynamicContentInString(this.interval));
    }

    public String getTime() {
        return this.time;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public String getInterval() {
        return this.interval;
    }

    public static class Builder
    extends AbstractTestActionBuilder<Wait, Builder>
    implements TestActionBuilder.DelegatingTestActionBuilder<Wait> {
        protected Condition condition;
        private String time = "5000";
        private String interval = "1000";
        private TestActionBuilder<?> delegate;

        public static Builder waitFor() {
            return new Builder();
        }

        public Builder condition(Condition condition) {
            this.condition = condition;
            this.delegate = this::build;
            return this;
        }

        public <T extends WaitConditionBuilder<? extends Condition, T>> T condition(T conditionBuilder) {
            this.condition = conditionBuilder.getCondition();
            this.delegate = conditionBuilder;
            return conditionBuilder;
        }

        public WaitMessageConditionBuilder message() {
            WaitMessageConditionBuilder builder;
            MessageCondition condition = new MessageCondition();
            this.condition = condition;
            this.delegate = builder = new WaitMessageConditionBuilder(condition, this);
            return builder;
        }

        public WaitActionConditionBuilder execution() {
            WaitActionConditionBuilder builder;
            ActionCondition condition = new ActionCondition();
            this.condition = condition;
            this.delegate = builder = new WaitActionConditionBuilder(condition, this);
            return builder;
        }

        public WaitHttpConditionBuilder http() {
            WaitHttpConditionBuilder builder;
            HttpCondition condition = new HttpCondition();
            this.condition = condition;
            this.delegate = builder = new WaitHttpConditionBuilder(condition, this);
            return builder;
        }

        public WaitFileConditionBuilder file() {
            WaitFileConditionBuilder builder;
            FileCondition condition = new FileCondition();
            this.condition = condition;
            this.delegate = builder = new WaitFileConditionBuilder(condition, this);
            return builder;
        }

        public Builder interval(Long interval) {
            return this.interval(String.valueOf(interval));
        }

        public Builder interval(String interval) {
            this.interval = interval;
            return this;
        }

        public Builder milliseconds(long milliseconds) {
            return this.milliseconds(String.valueOf(milliseconds));
        }

        public Builder milliseconds(String milliseconds) {
            this.time = milliseconds;
            return this;
        }

        public Builder seconds(double seconds) {
            this.milliseconds(Math.round(seconds * 1000.0));
            return this;
        }

        public Builder time(Duration duration) {
            this.milliseconds(duration.toMillis());
            return this;
        }

        public Wait build() {
            return new Wait(this);
        }

        public TestActionBuilder<?> getDelegate() {
            return this.delegate;
        }
    }
}

