/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions;

import com.consol.citrus.functions.Function;
import com.consol.citrus.functions.FunctionLibrary;
import com.consol.citrus.functions.core.AbsoluteFunction;
import com.consol.citrus.functions.core.AvgFunction;
import com.consol.citrus.functions.core.CeilingFunction;
import com.consol.citrus.functions.core.ChangeDateFunction;
import com.consol.citrus.functions.core.ConcatFunction;
import com.consol.citrus.functions.core.CurrentDateFunction;
import com.consol.citrus.functions.core.DecodeBase64Function;
import com.consol.citrus.functions.core.DigestAuthHeaderFunction;
import com.consol.citrus.functions.core.EncodeBase64Function;
import com.consol.citrus.functions.core.FloorFunction;
import com.consol.citrus.functions.core.LoadMessageFunction;
import com.consol.citrus.functions.core.LocalHostAddressFunction;
import com.consol.citrus.functions.core.LowerCaseFunction;
import com.consol.citrus.functions.core.MaxFunction;
import com.consol.citrus.functions.core.MinFunction;
import com.consol.citrus.functions.core.RandomEnumValueFunction;
import com.consol.citrus.functions.core.RandomNumberFunction;
import com.consol.citrus.functions.core.RandomStringFunction;
import com.consol.citrus.functions.core.RandomUUIDFunction;
import com.consol.citrus.functions.core.ReadFileResourceFunction;
import com.consol.citrus.functions.core.RoundFunction;
import com.consol.citrus.functions.core.StringLengthFunction;
import com.consol.citrus.functions.core.SubstringAfterFunction;
import com.consol.citrus.functions.core.SubstringBeforeFunction;
import com.consol.citrus.functions.core.SubstringFunction;
import com.consol.citrus.functions.core.SumFunction;
import com.consol.citrus.functions.core.SystemPropertyFunction;
import com.consol.citrus.functions.core.TranslateFunction;
import com.consol.citrus.functions.core.UpperCaseFunction;
import com.consol.citrus.functions.core.UrlDecodeFunction;
import com.consol.citrus.functions.core.UrlEncodeFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFunctionLibrary
extends FunctionLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFunctionLibrary.class);

    public DefaultFunctionLibrary() {
        this.setName("citrusFunctionLibrary");
        this.getMembers().put("randomNumber", new RandomNumberFunction());
        this.getMembers().put("randomString", new RandomStringFunction());
        this.getMembers().put("concat", new ConcatFunction());
        this.getMembers().put("currentDate", new CurrentDateFunction());
        this.getMembers().put("substring", new SubstringFunction());
        this.getMembers().put("stringLength", new StringLengthFunction());
        this.getMembers().put("translate", new TranslateFunction());
        this.getMembers().put("substringBefore", new SubstringBeforeFunction());
        this.getMembers().put("substringAfter", new SubstringAfterFunction());
        this.getMembers().put("round", new RoundFunction());
        this.getMembers().put("floor", new FloorFunction());
        this.getMembers().put("ceiling", new CeilingFunction());
        this.getMembers().put("upperCase", new UpperCaseFunction());
        this.getMembers().put("lowerCase", new LowerCaseFunction());
        this.getMembers().put("average", new AvgFunction());
        this.getMembers().put("minimum", new MinFunction());
        this.getMembers().put("maximum", new MaxFunction());
        this.getMembers().put("sum", new SumFunction());
        this.getMembers().put("absolute", new AbsoluteFunction());
        this.getMembers().put("randomEnumValue", new RandomEnumValueFunction());
        this.getMembers().put("randomUUID", new RandomUUIDFunction());
        this.getMembers().put("encodeBase64", new EncodeBase64Function());
        this.getMembers().put("decodeBase64", new DecodeBase64Function());
        this.getMembers().put("urlEncode", new UrlEncodeFunction());
        this.getMembers().put("urlDecode", new UrlDecodeFunction());
        this.getMembers().put("digestAuthHeader", new DigestAuthHeaderFunction());
        this.getMembers().put("localHostAddress", new LocalHostAddressFunction());
        this.getMembers().put("changeDate", new ChangeDateFunction());
        this.getMembers().put("readFile", new ReadFileResourceFunction());
        this.getMembers().put("message", new LoadMessageFunction());
        this.getMembers().put("systemProperty", new SystemPropertyFunction());
        this.lookupFunctions();
    }

    private void lookupFunctions() {
        Function.lookup().forEach((k, m) -> {
            this.getMembers().put(k, m);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Register function '%s' as %s", k, m.getClass()));
            }
        });
    }
}

