/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.builder;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.common.Named;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.message.MessageHeaderBuilder;
import com.consol.citrus.message.MessageHeaderDataBuilder;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageProcessorAdapter;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.WithHeaderBuilder;
import com.consol.citrus.message.WithPayloadBuilder;
import com.consol.citrus.message.builder.DefaultHeaderBuilder;
import com.consol.citrus.message.builder.DefaultHeaderDataBuilder;
import com.consol.citrus.message.builder.DefaultPayloadBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.ValidationContextAdapter;
import com.consol.citrus.validation.ValidationProcessor;
import com.consol.citrus.validation.builder.DefaultMessageBuilder;
import com.consol.citrus.validation.builder.StaticMessageBuilder;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.VariableExtractorAdapter;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;

public class ReceiveMessageBuilderSupport<T extends ReceiveMessageAction, B extends ReceiveMessageAction.ReceiveMessageActionBuilder<T, S, B>, S extends ReceiveMessageBuilderSupport<T, B, S>>
implements TestActionBuilder<T>,
ReferenceResolverAware {
    private final S self;
    private MessageBuilder messageBuilder = new DefaultMessageBuilder();
    private final List<MessageProcessor> controlMessageProcessors = new ArrayList<MessageProcessor>();
    private DataDictionary<?> dataDictionary;
    private String dataDictionaryName;
    private String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    private boolean headerNameIgnoreCase = false;
    protected final B delegate;

    protected ReceiveMessageBuilderSupport(B delegate) {
        this.self = this;
        this.delegate = delegate;
    }

    public S timeout(long receiveTimeout) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).timeout(receiveTimeout);
        return this.self;
    }

    public S from(MessageBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
        return this.self;
    }

    public S from(Message controlMessage) {
        this.messageBuilder = StaticMessageBuilder.withMessage(controlMessage);
        this.type(controlMessage.getType());
        return this.self;
    }

    public S name(String name) {
        if (!(this.messageBuilder instanceof Named)) {
            throw new CitrusRuntimeException("Unable to set message name on builder type: " + this.messageBuilder.getClass());
        }
        ((Named)this.messageBuilder).setName(name);
        return this.self;
    }

    public S body(MessagePayloadBuilder.Builder<?, ?> payloadBuilder) {
        this.body(payloadBuilder.build());
        return this.self;
    }

    public S body(MessagePayloadBuilder payloadBuilder) {
        if (!(this.messageBuilder instanceof WithPayloadBuilder)) {
            throw new CitrusRuntimeException("Unable to set payload builder on message builder type: " + this.messageBuilder.getClass());
        }
        ((WithPayloadBuilder)this.messageBuilder).setPayloadBuilder(payloadBuilder);
        return this.self;
    }

    public S body(String payload) {
        this.body(new DefaultPayloadBuilder(payload));
        return this.self;
    }

    public S body(Resource payloadResource) {
        return this.body(payloadResource, FileUtils.getDefaultCharset());
    }

    public S body(Resource payloadResource, Charset charset) {
        try {
            this.body(FileUtils.readToString(payloadResource, charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read payload resource", (Throwable)e);
        }
        return this.self;
    }

    public S header(String name, Object value) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(Collections.singletonMap(name, value)));
        return this.self;
    }

    public S headers(Map<String, Object> headers) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(headers));
        return this.self;
    }

    public S header(String data) {
        this.header(new DefaultHeaderDataBuilder(data));
        return this.self;
    }

    public S header(MessageHeaderDataBuilder headerDataBuilder) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)headerDataBuilder);
        return this.self;
    }

    public S header(Resource resource) {
        return this.header(resource, FileUtils.getDefaultCharset());
    }

    public S header(Resource resource, Charset charset) {
        try {
            if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
                throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
            }
            ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderDataBuilder(FileUtils.readToString(resource, charset)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read header resource", (Throwable)e);
        }
        return this.self;
    }

    public S headerNameIgnoreCase(boolean value) {
        this.headerNameIgnoreCase = value;
        return this.self;
    }

    public S type(MessageType messageType) {
        this.type(messageType.name());
        return this.self;
    }

    public S type(String messageType) {
        this.messageType = messageType;
        return this.self;
    }

    public S validate(ValidationContext.Builder<?, ?> validationContext) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).validate(validationContext);
        return this.self;
    }

    public S validate(ValidationContext validationContext) {
        return this.validate((ValidationContext.Builder<?, ?>)((ValidationContext.Builder)() -> validationContext));
    }

    public S validate(ValidationContextAdapter adapter) {
        return this.validate(adapter.asValidationContext());
    }

    public S validate(List<ValidationContext.Builder<?, ?>> validationContexts) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).validate(validationContexts);
        return this.self;
    }

    public S validate(ValidationContext.Builder<?, ?> ... validationContexts) {
        return this.validate(Arrays.asList(validationContexts));
    }

    public S selector(String messageSelector) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).selector(messageSelector);
        return this.self;
    }

    public S selector(Map<String, String> messageSelector) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).selector(messageSelector);
        return this.self;
    }

    public S validator(MessageValidator<? extends ValidationContext> validator) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).validator(validator);
        return this.self;
    }

    @SafeVarargs
    public final S validators(MessageValidator<? extends ValidationContext> ... validators) {
        return this.validators(Arrays.asList(validators));
    }

    public S validators(List<MessageValidator<? extends ValidationContext>> validators) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).validators(validators);
        return this.self;
    }

    public S validator(String ... validatorNames) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).validator(validatorNames);
        return this.self;
    }

    public S validator(HeaderValidator ... validators) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).validator(validators);
        return this.self;
    }

    public S dictionary(DataDictionary<?> dictionary) {
        this.dataDictionary = dictionary;
        return this.self;
    }

    public S dictionary(String dictionaryName) {
        this.dataDictionaryName = dictionaryName;
        return this.self;
    }

    public B validate(ValidationProcessor processor) {
        return ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).validate(processor);
    }

    public S process(MessageProcessor processor) {
        if (processor instanceof VariableExtractor) {
            ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).process(processor);
        } else {
            this.controlMessageProcessors.add(processor);
        }
        return this.self;
    }

    public S process(MessageProcessor.Builder<?, ?> builder) {
        return this.process(builder.build());
    }

    public S process(MessageProcessorAdapter adapter) {
        return this.process(adapter.asProcessor());
    }

    public S extract(VariableExtractor extractor) {
        return this.process((MessageProcessor)extractor);
    }

    public S extract(VariableExtractorAdapter adapter) {
        return this.extract(adapter.asExtractor());
    }

    public S extract(VariableExtractor.Builder<?, ?> builder) {
        return this.extract(builder.build());
    }

    public S withReferenceResolver(ReferenceResolver referenceResolver) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).withReferenceResolver(referenceResolver);
        return this.self;
    }

    public T build() {
        return (T)((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        ((ReceiveMessageAction.ReceiveMessageActionBuilder)this.delegate).setReferenceResolver(referenceResolver);
    }

    public String getDataDictionaryName() {
        return this.dataDictionaryName;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public List<MessageProcessor> getControlMessageProcessors() {
        return this.controlMessageProcessors;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public boolean isHeaderNameIgnoreCase() {
        return this.headerNameIgnoreCase;
    }
}

