/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.container.AbstractSuiteActionContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSuiteContainerBuilder<T extends AbstractSuiteActionContainer, S extends AbstractSuiteContainerBuilder<T, S>>
extends AbstractTestContainerBuilder<T, S> {
    private final List<String> suiteNames = new ArrayList<String>();
    private final List<String> testGroups = new ArrayList<String>();
    private final Map<String, String> env = new HashMap<String, String>();
    private final Map<String, String> systemProperties = new HashMap<String, String>();

    public S onSuite(String ... suiteNames) {
        return this.onSuites(Arrays.asList(suiteNames));
    }

    public S onSuites(List<String> suiteNames) {
        this.suiteNames.addAll(suiteNames);
        return (S)((AbstractSuiteContainerBuilder)this.self);
    }

    public S onTestGroup(String ... testGroups) {
        return this.onTestGroups(Arrays.asList(testGroups));
    }

    public S onTestGroups(List<String> testGroups) {
        this.testGroups.addAll(testGroups);
        return (S)((AbstractSuiteContainerBuilder)this.self);
    }

    public S whenSystemProperty(String name, String value) {
        this.systemProperties.put(name, value);
        return (S)((AbstractSuiteContainerBuilder)this.self);
    }

    public S whenSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties.putAll(systemProperties);
        return (S)((AbstractSuiteContainerBuilder)this.self);
    }

    public S whenEnv(String name, String value) {
        this.env.put(name, value);
        return (S)((AbstractSuiteContainerBuilder)this.self);
    }

    public S whenEnv(Map<String, String> envs) {
        this.env.putAll(envs);
        return (S)((AbstractSuiteContainerBuilder)this.self);
    }

    @Override
    public T build() {
        AbstractSuiteActionContainer container = (AbstractSuiteActionContainer)super.build();
        container.setSuiteNames(this.suiteNames);
        container.setTestGroups(this.testGroups);
        container.setSystemProperties(this.systemProperties);
        container.setEnv(this.env);
        return (T)container;
    }
}

