/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageSelectorBuilder;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ReceiveTimeoutAction
extends AbstractTestAction {
    private final long timeout;
    private final Endpoint endpoint;
    private final String endpointUri;
    private final Map<String, Object> messageSelectorMap;
    private final String messageSelector;
    private static Logger log = LoggerFactory.getLogger(ReceiveTimeoutAction.class);

    public ReceiveTimeoutAction(Builder builder) {
        super("receive-timeout", builder);
        this.endpoint = builder.endpoint;
        this.endpointUri = builder.endpointUri;
        this.timeout = builder.timeout;
        this.messageSelector = builder.messageSelector;
        this.messageSelectorMap = builder.messageSelectorMap;
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            Consumer consumer = this.getOrCreateEndpoint(context).createConsumer();
            String selector = MessageSelectorBuilder.build(this.messageSelector, this.messageSelectorMap, context);
            Message receivedMessage = StringUtils.hasText((String)selector) && consumer instanceof SelectiveConsumer ? ((SelectiveConsumer)consumer).receive(selector, context, this.timeout) : consumer.receive(context, this.timeout);
            if (receivedMessage != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Received message: " + receivedMessage.getPayload());
                }
                throw new CitrusRuntimeException("Message timeout validation failed! Received message while waiting for timeout on destination");
            }
        }
        catch (ActionTimeoutException e) {
            log.info("No messages received on destination. Message timeout validation OK!");
            log.info(e.getMessage());
        }
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText((String)this.endpointUri)) {
            return context.getEndpointFactory().create(this.endpointUri, context);
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public Map<String, Object> getMessageSelectorMap() {
        return this.messageSelectorMap;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<ReceiveTimeoutAction, Builder> {
        private long timeout = 1000L;
        private Endpoint endpoint;
        private String endpointUri;
        private Map<String, Object> messageSelectorMap = new HashMap<String, Object>();
        private String messageSelector;

        public static Builder expectTimeout(String endpointUri) {
            return Builder.receiveTimeout(endpointUri);
        }

        public static Builder expectTimeout(Endpoint endpoint) {
            return Builder.receiveTimeout(endpoint);
        }

        public static Builder receiveTimeout(String endpointUri) {
            Builder builder = new Builder();
            builder.endpoint(endpointUri);
            return builder;
        }

        public static Builder receiveTimeout(Endpoint endpoint) {
            Builder builder = new Builder();
            builder.endpoint(endpoint);
            return builder;
        }

        public Builder endpoint(Endpoint messageEndpoint) {
            this.endpoint = messageEndpoint;
            return this;
        }

        public Builder endpoint(String messageEndpointUri) {
            this.endpointUri = messageEndpointUri;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder selector(String messageSelector) {
            this.messageSelector = messageSelector;
            return this;
        }

        public Builder selector(Map<String, Object> messageSelector) {
            this.messageSelectorMap = messageSelector;
            return this;
        }

        public ReceiveTimeoutAction build() {
            return new ReceiveTimeoutAction(this);
        }
    }
}

