/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.Completable;
import com.consol.citrus.TestAction;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.builder.SendMessageBuilderSupport;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.IsJsonPredicate;
import com.consol.citrus.util.IsXmlPredicate;
import com.consol.citrus.validation.SchemaValidator;
import com.consol.citrus.validation.context.DefaultValidationContext;
import com.consol.citrus.validation.context.SchemaValidationContext;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.StringUtils;

public class SendMessageAction
extends AbstractTestAction
implements Completable {
    private static final String REPORT_ENABLED_ENV = "CITRUS_SUMMARY_REPORT_ENABLED";
    private final Endpoint endpoint;
    private final String endpointUri;
    private final boolean schemaValidation;
    private final String schemaRepository;
    private final String schema;
    private final List<VariableExtractor> variableExtractors;
    private final List<MessageProcessor> messageProcessors;
    private final MessageBuilder messageBuilder;
    private final boolean forkMode;
    private final String messageType;
    private final DataDictionary<?> dataDictionary;
    private CompletableFuture<Void> finished;
    private static final Logger LOG = LoggerFactory.getLogger(SendMessageAction.class);

    public SendMessageAction(SendMessageActionBuilder<?, ?, ?> builder) {
        super("send", builder);
        this.endpoint = builder.endpoint;
        this.endpointUri = builder.endpointUri;
        this.schemaValidation = ((SendMessageBuilderSupport)builder.messageBuilderSupport).isSchemaValidation();
        this.schema = ((SendMessageBuilderSupport)builder.messageBuilderSupport).getSchema();
        this.schemaRepository = ((SendMessageBuilderSupport)builder.messageBuilderSupport).getSchemaRepository();
        this.variableExtractors = builder.variableExtractors;
        this.messageProcessors = builder.messageProcessors;
        this.forkMode = builder.forkMode;
        this.messageBuilder = ((SendMessageBuilderSupport)builder.messageBuilderSupport).getMessageBuilder();
        this.messageType = ((SendMessageBuilderSupport)builder.messageBuilderSupport).getMessageType();
        this.dataDictionary = ((SendMessageBuilderSupport)builder.messageBuilderSupport).getDataDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(TestContext context) {
        Message message = this.createMessage(context, this.messageType);
        this.finished = new CompletableFuture();
        for (VariableExtractor variableExtractor : this.variableExtractors) {
            variableExtractor.extractVariables(message, context);
        }
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (StringUtils.hasText((String)message.getName())) {
            context.getMessageStore().storeMessage(message.getName(), message);
        } else {
            context.getMessageStore().storeMessage(context.getMessageStore().constructMessageName((TestAction)this, messageEndpoint), message);
        }
        if (this.forkMode) {
            LOG.debug("Forking message sending action ...");
            SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
            taskExecutor.execute(() -> {
                try {
                    this.validateMessage(message, context);
                    messageEndpoint.createProducer().send(message, context);
                }
                catch (Exception e) {
                    if (e instanceof CitrusRuntimeException) {
                        context.addException((CitrusRuntimeException)((Object)((Object)e)));
                    } else {
                        context.addException(new CitrusRuntimeException((Throwable)e));
                    }
                }
                finally {
                    this.finished.complete(null);
                }
            });
        } else {
            try {
                this.validateMessage(message, context);
                messageEndpoint.createProducer().send(message, context);
            }
            finally {
                this.finished.complete(null);
            }
        }
    }

    protected void validateMessage(Message message, TestContext context) {
        List schemaValidators = null;
        DefaultValidationContext validationContext = null;
        String payload = (String)message.getPayload(String.class);
        if ((this.isSchemaValidation() || SendMessageAction.isJsonSchemaValidationEnabled()) && IsJsonPredicate.getInstance().test(payload)) {
            schemaValidators = context.getMessageValidatorRegistry().findSchemaValidators(MessageType.JSON.name(), message);
            validationContext = JsonMessageValidationContext.Builder.json().schemaValidation(this.schemaValidation).schema(this.schema).schemaRepository(this.schemaRepository).build();
        } else if ((this.isSchemaValidation() || SendMessageAction.isXmlSchemaValidationEnabled()) && IsXmlPredicate.getInstance().test(payload)) {
            schemaValidators = context.getMessageValidatorRegistry().findSchemaValidators(MessageType.XML.name(), message);
            validationContext = ((XmlMessageValidationContext.Builder)((XmlMessageValidationContext.Builder)((XmlMessageValidationContext.Builder)XmlMessageValidationContext.Builder.xml().schemaValidation(this.schemaValidation)).schema(this.schema)).schemaRepository(this.schemaRepository)).build();
        }
        if (schemaValidators != null) {
            for (SchemaValidator validator : schemaValidators) {
                validator.validate(message, context, (SchemaValidationContext)validationContext);
            }
        }
    }

    private static boolean isJsonSchemaValidationEnabled() {
        return Boolean.getBoolean("citrus.validation.outbound.schema.enabled") || Boolean.getBoolean("citrus.validation.outbound.json.schema.enabled") || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_SCHEMA_ENABLED")) || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_JSON_SCHEMA_ENABLED"));
    }

    private static boolean isXmlSchemaValidationEnabled() {
        return Boolean.getBoolean("citrus.validation.outbound.schema.enabled") || Boolean.getBoolean("citrus.validation.outbound.xml.schema.enabled") || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_SCHEMA_ENABLED")) || Boolean.parseBoolean(System.getenv("CITRUS_VALIDATION_OUTBOUND_XML_SCHEMA_ENABLED"));
    }

    @Override
    public boolean isDisabled(TestContext context) {
        Endpoint messageEndpoint = this.getOrCreateEndpoint(context);
        if (this.getActor() == null && messageEndpoint.getActor() != null) {
            return messageEndpoint.getActor().isDisabled();
        }
        return super.isDisabled(context);
    }

    public boolean isDone(TestContext context) {
        return Optional.ofNullable(this.finished).map(future -> future.isDone() || this.isDisabled(context)).orElse(this.isDisabled(context));
    }

    protected Message createMessage(TestContext context, String messageType) {
        Message message = this.messageBuilder.build(context, messageType);
        if (message.getPayload() != null) {
            context.getMessageProcessors(MessageDirection.OUTBOUND).forEach(processor -> processor.process(message, context));
            if (this.dataDictionary != null) {
                this.dataDictionary.process(message, context);
            }
            this.messageProcessors.forEach(processor -> processor.process(message, context));
        }
        return message;
    }

    public Endpoint getOrCreateEndpoint(TestContext context) {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        if (StringUtils.hasText((String)this.endpointUri)) {
            return context.getEndpointFactory().create(this.endpointUri, context);
        }
        throw new CitrusRuntimeException("Neither endpoint nor endpoint uri is set properly!");
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public String getSchemaRepository() {
        return this.schemaRepository;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<VariableExtractor> getVariableExtractors() {
        return this.variableExtractors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public boolean isForkMode() {
        return this.forkMode;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public static abstract class SendMessageActionBuilder<T extends SendMessageAction, M extends SendMessageBuilderSupport<T, B, M>, B extends SendMessageActionBuilder<T, M, B>>
    extends AbstractTestActionBuilder<T, B>
    implements ReferenceResolverAware {
        protected Endpoint endpoint;
        protected String endpointUri;
        protected boolean forkMode = false;
        protected CompletableFuture<Void> finished;
        protected List<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
        protected List<MessageProcessor> messageProcessors = new ArrayList<MessageProcessor>();
        protected ReferenceResolver referenceResolver;
        protected M messageBuilderSupport;

        public B endpoint(Endpoint messageEndpoint) {
            this.endpoint = messageEndpoint;
            return (B)((SendMessageActionBuilder)this.self);
        }

        public B endpoint(String messageEndpointUri) {
            this.endpointUri = messageEndpointUri;
            return (B)((SendMessageActionBuilder)this.self);
        }

        public B fork(boolean forkMode) {
            this.forkMode = forkMode;
            return (B)((SendMessageActionBuilder)this.self);
        }

        public M message() {
            return this.getMessageBuilderSupport();
        }

        public M message(MessageBuilder messageBuilder) {
            return (M)((SendMessageBuilderSupport)this.getMessageBuilderSupport()).from(messageBuilder);
        }

        public M message(Message controlMessage) {
            return (M)((SendMessageBuilderSupport)this.getMessageBuilderSupport()).from(controlMessage);
        }

        public B transform(MessageProcessor processor) {
            return this.process(processor);
        }

        public B transform(MessageProcessor.Builder<?, ?> builder) {
            return this.transform(builder.build());
        }

        public B process(MessageProcessor processor) {
            if (processor instanceof VariableExtractor) {
                this.variableExtractors.add((VariableExtractor)processor);
            } else {
                this.messageProcessors.add(processor);
            }
            return (B)((SendMessageActionBuilder)this.self);
        }

        public B process(MessageProcessor.Builder<?, ?> builder) {
            return this.process(builder.build());
        }

        public B withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return (B)((SendMessageActionBuilder)this.self);
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public M getMessageBuilderSupport() {
            return this.messageBuilderSupport;
        }

        protected abstract T doBuild();

        public final T build() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = this.getMessageBuilderSupport();
            }
            if (this.referenceResolver != null && ((SendMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName() != null) {
                ((SendMessageBuilderSupport)this.messageBuilderSupport).dictionary((DataDictionary)this.referenceResolver.resolve(((SendMessageBuilderSupport)this.messageBuilderSupport).getDataDictionaryName(), DataDictionary.class));
            }
            return this.doBuild();
        }
    }

    public static class SendMessageActionBuilderSupport
    extends SendMessageBuilderSupport<SendMessageAction, Builder, SendMessageActionBuilderSupport> {
        public SendMessageActionBuilderSupport(Builder delegate) {
            super(delegate);
        }
    }

    public static final class Builder
    extends SendMessageActionBuilder<SendMessageAction, SendMessageActionBuilderSupport, Builder> {
        public static Builder send() {
            return new Builder();
        }

        public static Builder send(Endpoint messageEndpoint) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpoint);
            return builder;
        }

        public static Builder send(String messageEndpointUri) {
            Builder builder = new Builder();
            builder.endpoint(messageEndpointUri);
            return builder;
        }

        @Override
        public SendMessageActionBuilderSupport getMessageBuilderSupport() {
            if (this.messageBuilderSupport == null) {
                this.messageBuilderSupport = new SendMessageActionBuilderSupport((Builder)this.self);
            }
            return (SendMessageActionBuilderSupport)super.getMessageBuilderSupport();
        }

        @Override
        public SendMessageAction doBuild() {
            return new SendMessageAction(this);
        }
    }
}

