/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message.builder;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.common.Named;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.message.MessageHeaderBuilder;
import com.consol.citrus.message.MessageHeaderDataBuilder;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageProcessorAdapter;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.WithHeaderBuilder;
import com.consol.citrus.message.WithPayloadBuilder;
import com.consol.citrus.message.builder.DefaultHeaderBuilder;
import com.consol.citrus.message.builder.DefaultHeaderDataBuilder;
import com.consol.citrus.message.builder.DefaultPayloadBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.builder.DefaultMessageBuilder;
import com.consol.citrus.validation.builder.StaticMessageBuilder;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.VariableExtractorAdapter;
import com.consol.citrus.variable.dictionary.DataDictionary;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.io.Resource;

public class SendMessageBuilderSupport<T extends SendMessageAction, B extends SendMessageAction.SendMessageActionBuilder<T, S, B>, S extends SendMessageBuilderSupport<T, B, S>>
implements TestActionBuilder<T>,
ReferenceResolverAware {
    protected final S self;
    private MessageBuilder messageBuilder = new DefaultMessageBuilder();
    private DataDictionary<?> dataDictionary;
    private String dataDictionaryName;
    protected boolean schemaValidation;
    protected String schema;
    protected String schemaRepository;
    private String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    protected final B delegate;

    protected SendMessageBuilderSupport(B delegate) {
        this.self = this;
        this.delegate = delegate;
    }

    public S fork(boolean forkMode) {
        ((SendMessageAction.SendMessageActionBuilder)this.delegate).fork(forkMode);
        return this.self;
    }

    public S from(MessageBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
        return this.self;
    }

    public S from(Message controlMessage) {
        this.messageBuilder = StaticMessageBuilder.withMessage(controlMessage);
        this.type(controlMessage.getType());
        return this.self;
    }

    public S name(String name) {
        if (!(this.messageBuilder instanceof Named)) {
            throw new CitrusRuntimeException("Unable to set message name on builder type: " + this.messageBuilder.getClass());
        }
        ((Named)this.messageBuilder).setName(name);
        return this.self;
    }

    public S body(MessagePayloadBuilder.Builder<?, ?> payloadBuilder) {
        this.body(payloadBuilder.build());
        return this.self;
    }

    public S body(MessagePayloadBuilder payloadBuilder) {
        if (!(this.messageBuilder instanceof WithPayloadBuilder)) {
            throw new CitrusRuntimeException("Unable to set payload builder on message builder type: " + this.messageBuilder.getClass());
        }
        ((WithPayloadBuilder)this.messageBuilder).setPayloadBuilder(payloadBuilder);
        return this.self;
    }

    public S body(String payload) {
        this.body(new DefaultPayloadBuilder(payload));
        return this.self;
    }

    public S body(Resource payloadResource) {
        return this.body(payloadResource, FileUtils.getDefaultCharset());
    }

    public S body(Resource payloadResource, Charset charset) {
        try {
            this.body(FileUtils.readToString(payloadResource, charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read payload resource", (Throwable)e);
        }
        return this.self;
    }

    public S header(String name, Object value) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(Collections.singletonMap(name, value)));
        return this.self;
    }

    public S headers(Map<String, Object> headers) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderBuilder(headers));
        return this.self;
    }

    public S header(String data) {
        this.header(new DefaultHeaderDataBuilder(data));
        return this.self;
    }

    public S header(MessageHeaderDataBuilder headerDataBuilder) {
        if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
            throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
        }
        ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)headerDataBuilder);
        return this.self;
    }

    public S header(Resource resource) {
        return this.header(resource, FileUtils.getDefaultCharset());
    }

    public S header(Resource resource, Charset charset) {
        try {
            if (!(this.messageBuilder instanceof WithHeaderBuilder)) {
                throw new CitrusRuntimeException("Unable to set message header data on builder type: " + this.messageBuilder.getClass());
            }
            ((WithHeaderBuilder)this.messageBuilder).addHeaderBuilder((MessageHeaderBuilder)new DefaultHeaderDataBuilder(FileUtils.readToString(resource, charset)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read header resource", (Throwable)e);
        }
        return this.self;
    }

    public S type(MessageType messageType) {
        this.type(messageType.name());
        return this.self;
    }

    public S type(String messageType) {
        this.messageType = messageType;
        return this.self;
    }

    public S schemaValidation(boolean enabled) {
        this.schemaValidation = enabled;
        return this.self;
    }

    public boolean isSchemaValidation() {
        return this.schemaValidation;
    }

    public S schema(String schemaName) {
        this.schema = schemaName;
        return this.self;
    }

    public String getSchema() {
        return this.schema;
    }

    public S schemaRepository(String schemaRepository) {
        this.schemaRepository = schemaRepository;
        return this.self;
    }

    public String getSchemaRepository() {
        return this.schemaRepository;
    }

    public S transform(MessageProcessor processor) {
        return this.process(processor);
    }

    public S transform(MessageProcessor.Builder<?, ?> builder) {
        return this.transform(builder.build());
    }

    public S process(MessageProcessor processor) {
        ((SendMessageAction.SendMessageActionBuilder)this.delegate).process(processor);
        return this.self;
    }

    public S process(MessageProcessor.Builder<?, ?> builder) {
        return this.process(builder.build());
    }

    public S process(MessageProcessorAdapter adapter) {
        return this.process(adapter.asProcessor());
    }

    public S extract(VariableExtractor extractor) {
        return this.process((MessageProcessor)extractor);
    }

    public S extract(VariableExtractorAdapter adapter) {
        return this.extract(adapter.asExtractor());
    }

    public S extract(VariableExtractor.Builder<?, ?> builder) {
        return this.extract(builder.build());
    }

    public S dictionary(DataDictionary<?> dictionary) {
        this.dataDictionary = dictionary;
        return this.self;
    }

    public S dictionary(String dictionaryName) {
        this.dataDictionaryName = dictionaryName;
        return this.self;
    }

    public S withReferenceResolver(ReferenceResolver referenceResolver) {
        ((SendMessageAction.SendMessageActionBuilder)this.delegate).withReferenceResolver(referenceResolver);
        return this.self;
    }

    public T build() {
        return (T)((SendMessageAction.SendMessageActionBuilder)this.delegate).build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        ((SendMessageAction.SendMessageActionBuilder)this.delegate).setReferenceResolver(referenceResolver);
    }

    public String getDataDictionaryName() {
        return this.dataDictionaryName;
    }

    public DataDictionary<?> getDataDictionary() {
        return this.dataDictionary;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public String getMessageType() {
        return this.messageType;
    }
}

