/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.report.TestReporter;
import com.consol.citrus.report.TestReporterSettings;
import com.consol.citrus.report.TestResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestReporter
implements TestReporter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean ignoreErrors = TestReporterSettings.isIgnoreErrors();
    private String reportDirectory = TestReporterSettings.getReportDirectory();

    public final void generateReport(TestResults testResults) {
        try {
            this.generate(testResults);
        }
        catch (Exception e) {
            if (this.ignoreErrors) {
                this.log.error("Failed to create test report", (Throwable)e);
            }
            throw e;
        }
    }

    protected abstract void generate(TestResults var1);

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }
}

