/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public abstract class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);
    public static final String FILE_EXTENSION_JAVA = ".java";
    public static final String FILE_EXTENSION_XML = ".xml";
    public static final String FILE_PATH_CHARSET_PARAMETER = ";charset=";
    private static boolean simulationMode = false;

    private FileUtils() {
    }

    public static void setSimulationMode(boolean mode) {
        simulationMode = mode;
    }

    public static String readToString(Resource resource) throws IOException {
        return FileUtils.readToString(resource, FileUtils.getDefaultCharset());
    }

    public static String readToString(InputStream inputStream) throws IOException {
        return FileUtils.readToString(inputStream, FileUtils.getDefaultCharset());
    }

    public static String readToString(File file) throws IOException {
        return FileUtils.readToString(new FileInputStream(file), FileUtils.getDefaultCharset());
    }

    public static String readToString(Resource resource, Charset charset) throws IOException {
        if (simulationMode) {
            if (resource instanceof ClassPathResource) {
                return ((ClassPathResource)resource).getPath();
            }
            if (resource instanceof FileSystemResource) {
                return ((FileSystemResource)resource).getPath();
            }
            return resource.getFilename();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Reading file resource: '%s' (encoding is '%s')", resource.getFilename(), charset.displayName()));
        }
        return FileUtils.readToString(resource.getInputStream(), charset);
    }

    public static String readToString(InputStream inputStream, Charset charset) throws IOException {
        return new String(FileCopyUtils.copyToByteArray((InputStream)inputStream), charset);
    }

    public static void writeToFile(InputStream inputStream, File file) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            FileUtils.writeToFile(FileCopyUtils.copyToString((Reader)inputStreamReader), file, FileUtils.getDefaultCharset());
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write file", (Throwable)e);
        }
    }

    public static void writeToFile(String content, File file) {
        FileUtils.writeToFile(content, file, FileUtils.getDefaultCharset());
    }

    public static void writeToFile(String content, File file, Charset charset) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Writing file resource: '%s' (encoding is '%s')", file.getName(), charset.displayName()));
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new CitrusRuntimeException("Unable to create folder structure for file: " + file.getPath());
        }
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));){
            ((OutputStream)fos).write(content.getBytes(charset));
            ((OutputStream)fos).flush();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write file", (Throwable)e);
        }
    }

    public static List<File> findFiles(String startDir, Set<String> fileNamePatterns) {
        ArrayList<File> files = new ArrayList<File>();
        Stack<File> dirs = new Stack<File>();
        File startdir = new File(startDir);
        if (!startdir.exists()) {
            throw new CitrusRuntimeException("Test directory " + startdir.getAbsolutePath() + " does not exist");
        }
        if (startdir.isDirectory()) {
            dirs.push(startdir);
        }
        while (dirs.size() > 0) {
            File file = (File)dirs.pop();
            File[] foundFiles = file.listFiles((dir, name) -> {
                File tmp = new File(dir.getPath() + File.separator + name);
                boolean accepted = tmp.isDirectory();
                for (String fileNamePattern : fileNamePatterns) {
                    if (fileNamePattern.contains("/")) {
                        fileNamePattern = fileNamePattern.substring(fileNamePattern.lastIndexOf(47) + 1);
                    }
                    if (!name.matches(fileNamePattern = fileNamePattern.replace(".", "\\.").replace("*", ".*"))) continue;
                    accepted = true;
                }
                return accepted && !name.startsWith("CVS") && !name.startsWith(".svn") && !name.startsWith(".git");
            });
            for (File found : Optional.ofNullable(foundFiles).orElse(new File[0])) {
                if (found.isDirectory()) {
                    dirs.push(found);
                    continue;
                }
                files.add(found);
            }
        }
        return files;
    }

    public static Resource getFileResource(String filePath, TestContext context) {
        if (filePath.contains(FILE_PATH_CHARSET_PARAMETER)) {
            return new PathMatchingResourcePatternResolver().getResource(context.replaceDynamicContentInString(filePath.substring(0, filePath.indexOf(FILE_PATH_CHARSET_PARAMETER))));
        }
        return new PathMatchingResourcePatternResolver().getResource(context.replaceDynamicContentInString(filePath));
    }

    public static Resource getFileResource(String filePath) {
        String path = filePath.contains(FILE_PATH_CHARSET_PARAMETER) ? filePath.substring(0, filePath.indexOf(FILE_PATH_CHARSET_PARAMETER)) : filePath;
        if (path.startsWith("file:")) {
            return new FileSystemResource(path.substring("file:".length()));
        }
        if (path.startsWith("classpath:")) {
            return new PathMatchingResourcePatternResolver().getResource(path);
        }
        FileSystemResource file = new FileSystemResource(path);
        if (!file.exists()) {
            return new PathMatchingResourcePatternResolver().getResource(path);
        }
        return file;
    }

    public static Charset getDefaultCharset() {
        return Charset.forName(CitrusSettings.CITRUS_FILE_ENCODING);
    }

    public static Charset getCharset(String path) {
        if (path.contains(FILE_PATH_CHARSET_PARAMETER)) {
            return Charset.forName(path.substring(path.indexOf(FILE_PATH_CHARSET_PARAMETER) + FILE_PATH_CHARSET_PARAMETER.length()));
        }
        return FileUtils.getDefaultCharset();
    }

    public static String getFileExtension(String path) {
        if (path.indexOf(".") > 0) {
            return path.substring(path.lastIndexOf(".") + 1);
        }
        return "";
    }

    public static Properties loadAsProperties(Resource resource) {
        Properties properties = new Properties();
        try (InputStream is = resource.getInputStream();){
            String filename = resource.getFilename();
            if (filename != null && filename.endsWith(FILE_EXTENSION_XML)) {
                properties.loadFromXML(is);
            } else {
                properties.load(is);
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to load properties from file", (Throwable)e);
        }
        return properties;
    }

    public static String getBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        if (fileName.indexOf(46) > 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }
}

