/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.builder;

import com.consol.citrus.common.Named;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.message.MessageHeaderBuilder;
import com.consol.citrus.message.MessageHeaderDataBuilder;
import com.consol.citrus.message.MessageHeaderType;
import com.consol.citrus.message.MessageHeaderUtils;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageTypeAware;
import com.consol.citrus.message.WithHeaderBuilder;
import com.consol.citrus.message.WithPayloadBuilder;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DefaultMessageBuilder
implements MessageBuilder,
WithPayloadBuilder,
WithHeaderBuilder,
Named {
    private String name = "";
    private MessagePayloadBuilder payloadBuilder;
    private final List<MessageHeaderBuilder> headerBuilders = new ArrayList<MessageHeaderBuilder>();

    public Message build(TestContext context, String messageType) {
        Object payload = this.buildMessagePayload(context, messageType);
        try {
            DefaultMessage message = new DefaultMessage(payload, this.buildMessageHeaders(context));
            message.setName(this.name);
            message.setType(messageType);
            message.getHeaderData().addAll(this.buildMessageHeaderData(context));
            return message;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to build message content", (Throwable)e);
        }
    }

    public Object buildMessagePayload(TestContext context, String messageType) {
        if (this.payloadBuilder == null) {
            return "";
        }
        if (this.payloadBuilder instanceof MessageTypeAware) {
            ((MessageTypeAware)this.payloadBuilder).setMessageType(messageType);
        }
        return this.payloadBuilder.buildPayload(context);
    }

    public Map<String, Object> buildMessageHeaders(TestContext context) {
        try {
            LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
            for (MessageHeaderBuilder messageHeaderBuilder : this.headerBuilders) {
                headers.putAll(messageHeaderBuilder.builderHeaders(context));
            }
            for (Map.Entry entry : headers.entrySet()) {
                String value = Optional.ofNullable(entry.getValue()).filter(String.class::isInstance).map(Object::toString).orElse("");
                if (!MessageHeaderType.isTyped((String)value)) continue;
                MessageHeaderType type = MessageHeaderType.fromTypedValue((String)value);
                Constructor constr = type.getHeaderClass().getConstructor(String.class);
                entry.setValue(constr.newInstance(MessageHeaderType.removeTypeDefinition((String)value)));
            }
            MessageHeaderUtils.checkHeaderTypes(headers);
            return headers;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to build message content", (Throwable)e);
        }
    }

    public List<String> buildMessageHeaderData(TestContext context) {
        ArrayList<String> headerData = new ArrayList<String>();
        for (MessageHeaderBuilder builder : this.headerBuilders) {
            if (!(builder instanceof MessageHeaderDataBuilder)) continue;
            headerData.add(((MessageHeaderDataBuilder)builder).buildHeaderData(context));
        }
        return headerData;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addHeaderBuilder(MessageHeaderBuilder headerBuilder) {
        this.headerBuilders.add(headerBuilder);
    }

    public void setPayloadBuilder(MessagePayloadBuilder payloadBuilder) {
        this.payloadBuilder = payloadBuilder;
    }

    public MessagePayloadBuilder getPayloadBuilder() {
        return this.payloadBuilder;
    }

    public List<MessageHeaderBuilder> getHeaderBuilders() {
        return this.headerBuilders;
    }
}

