/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.builder;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.builder.DefaultHeaderBuilder;
import com.consol.citrus.message.builder.DefaultHeaderDataBuilder;
import com.consol.citrus.message.builder.DefaultPayloadBuilder;
import com.consol.citrus.validation.builder.DefaultMessageBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaticMessageBuilder
extends DefaultMessageBuilder {
    protected static final List<String> FILTERED_HEADERS = Arrays.asList("citrus_message_id", "citrus_message_timestamp");
    private final Message message;

    public StaticMessageBuilder(Message message) {
        this.message = message;
        this.setName(message.getName());
    }

    @Override
    public Object buildMessagePayload(TestContext context, String messageType) {
        if (this.getPayloadBuilder() == null) {
            this.setPayloadBuilder(new DefaultPayloadBuilder(this.message.getPayload()));
        }
        return super.buildMessagePayload(context, messageType);
    }

    @Override
    public Map<String, Object> buildMessageHeaders(TestContext context) {
        Map<String, Object> headers = super.buildMessageHeaders(context);
        headers.putAll(new DefaultHeaderBuilder(this.message.getHeaders().entrySet().stream().filter(entry -> !FILTERED_HEADERS.contains(entry.getKey())).collect(HashMap::new, (map, value) -> map.put((String)value.getKey(), value.getValue()), HashMap::putAll)).builderHeaders(context));
        return headers;
    }

    @Override
    public List<String> buildMessageHeaderData(TestContext context) {
        List<String> headerData = super.buildMessageHeaderData(context);
        this.message.getHeaderData().stream().map(DefaultHeaderDataBuilder::new).forEach(builder -> headerData.add(builder.buildHeaderData(context)));
        return headerData;
    }

    public static StaticMessageBuilder withMessage(Message message) {
        return new StaticMessageBuilder(message);
    }

    public Message getMessage() {
        return this.message;
    }
}

