/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.variable.VariableUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateVariablesAction
extends AbstractTestAction {
    private final Map<String, String> variables;
    private static Logger log = LoggerFactory.getLogger(CreateVariablesAction.class);

    private CreateVariablesAction(Builder builder) {
        super("create-variables", builder);
        this.variables = builder.variables;
    }

    @Override
    public void doExecute(TestContext context) {
        for (Map.Entry<String, String> entry : this.variables.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value.startsWith("script:<")) {
                String scriptEngine = value.substring("script:<".length(), value.indexOf(62));
                value = VariableUtils.getValueFromScript((String)scriptEngine, (String)context.replaceDynamicContentInString(value.substring(value.indexOf(62) + 1)));
            }
            value = context.replaceDynamicContentInString(value);
            log.info("Setting variable: " + key + " to value: " + value);
            context.setVariable(key, (Object)value);
        }
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<CreateVariablesAction, Builder> {
        private Map<String, String> variables = new LinkedHashMap<String, String>();

        public static Builder createVariable(String variableName, String value) {
            Builder builder = new Builder();
            builder.variable(variableName, value);
            return builder;
        }

        public static Builder createVariables() {
            return new Builder();
        }

        public Builder variable(String variableName, String value) {
            this.variables.put(variableName, value);
            return this;
        }

        public CreateVariablesAction build() {
            return new CreateVariablesAction(this);
        }
    }
}

