/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.common;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class DefaultTestLoader
implements TestLoader {
    @CitrusFramework
    protected Citrus citrus;
    @CitrusResource
    protected CitrusContext citrusContext;
    @CitrusResource
    protected TestContext context;
    @CitrusResource
    protected TestCaseRunner runner;
    protected TestCase testCase;
    protected Class<?> testClass;
    protected String testName;
    protected String packageName;
    protected final List<Consumer<TestCase>> configurer = new ArrayList<Consumer<TestCase>>();
    protected final List<Consumer<TestCase>> handler = new ArrayList<Consumer<TestCase>>();

    public final void load() {
        if (this.testCase != null) {
            return;
        }
        this.initializeTestRunner();
        try {
            this.doLoad();
        }
        catch (TestCaseFailedException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            if (this.testCase == null) {
                this.testCase = this.runner.getTestCase();
            }
            this.testCase.setTestResult(TestResult.failed((String)this.testCase.getName(), (String)this.testCase.getTestClass().getName(), (Throwable)e));
            throw new TestCaseFailedException((Throwable)e);
        }
    }

    protected void doLoad() {
        try {
            this.testCase = this.runner.getTestCase();
            this.configurer.forEach(it -> it.accept(this.testCase));
            this.runner.start();
            this.handler.forEach(it -> it.accept(this.testCase));
        }
        finally {
            this.runner.stop();
        }
    }

    protected void initializeTestRunner() {
        if (this.runner == null) {
            if (this.context == null) {
                if (this.citrus == null) {
                    throw new CitrusRuntimeException("Missing Citrus framework instance for loading test");
                }
                this.context = this.citrus.getCitrusContext().createTestContext();
            }
            if (this.testCase == null) {
                this.testCase = new DefaultTestCase();
            }
            this.runner = new DefaultTestCaseRunner(this.testCase, this.context);
        }
        if (this.testClass == null) {
            this.testClass = this.runner.getTestCase().getTestClass();
        } else {
            this.runner.testClass(this.testClass);
        }
        if (this.testName == null) {
            this.testName = this.runner.getTestCase().getName();
        } else {
            this.runner.name(this.testName);
        }
        if (this.packageName == null) {
            this.packageName = this.runner.getTestCase().getPackageName();
        } else {
            this.runner.packageName(this.packageName);
        }
    }

    public void setTestClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public void doWithTestCase(Consumer<TestCase> handler) {
        this.handler.add(handler);
    }

    public void configureTestCase(Consumer<TestCase> configurer) {
        this.configurer.add(configurer);
    }
}

