/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestBoundaryContainerBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractTestBoundaryActionContainer;
import com.consol.citrus.container.AfterTest;
import com.consol.citrus.context.TestContext;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SequenceAfterTest
extends AbstractTestBoundaryActionContainer
implements AfterTest {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceAfterTest.class);

    @Override
    public void doExecute(TestContext context) {
        if (CollectionUtils.isEmpty((Collection)this.actions)) {
            return;
        }
        LOG.info("Entering after test block");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing " + this.actions.size() + " actions after test");
            LOG.debug("");
        }
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            action.execute(context);
        }
    }

    public static class Builder
    extends AbstractTestBoundaryContainerBuilder<SequenceAfterTest, Builder> {
        public static Builder afterTest() {
            return new Builder();
        }

        @Override
        public SequenceAfterTest doBuild() {
            return new SequenceAfterTest();
        }
    }
}

