/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint.direct;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointComponent;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.endpoint.direct.DirectEndpoint;
import com.consol.citrus.endpoint.direct.DirectSyncEndpoint;
import com.consol.citrus.endpoint.direct.DirectSyncEndpointConfiguration;
import com.consol.citrus.message.DefaultMessageQueue;
import java.util.Map;

public class DirectEndpointComponent
extends AbstractEndpointComponent {
    public DirectEndpointComponent() {
        super("direct");
    }

    @Override
    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        String queueName;
        DirectEndpoint endpoint;
        if (resourcePath.startsWith("sync:")) {
            DirectSyncEndpointConfiguration endpointConfiguration = new DirectSyncEndpointConfiguration();
            endpoint = new DirectSyncEndpoint(endpointConfiguration);
            queueName = resourcePath.substring("sync:".length());
        } else {
            endpoint = new DirectEndpoint();
            queueName = resourcePath;
        }
        endpoint.getEndpointConfiguration().setQueueName(queueName);
        if (!context.getReferenceResolver().isResolvable(queueName)) {
            context.getReferenceResolver().bind(queueName, (Object)new DefaultMessageQueue(queueName));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)endpoint.getEndpointConfiguration(), parameters, context);
        return endpoint;
    }
}

