/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.ConditionExpression;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.util.BooleanExpressionParser;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conditional
extends AbstractActionContainer {
    private static Logger log = LoggerFactory.getLogger(Conditional.class);
    private final String condition;
    private final ConditionExpression conditionExpression;

    public Conditional(Builder builder) {
        super("conditional", builder);
        this.condition = builder.condition;
        this.conditionExpression = builder.conditionExpression;
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.checkCondition(context)) {
            log.debug("Condition [ {} ] evaluates to true, executing nested actions", (Object)this.condition);
            for (TestActionBuilder actionBuilder : this.actions) {
                this.executeAction(actionBuilder.build(), context);
            }
        } else {
            log.debug("Condition [ {} ] evaluates to false, not executing nested actions", (Object)this.condition);
        }
    }

    private boolean checkCondition(TestContext context) {
        if (this.conditionExpression != null) {
            return this.conditionExpression.evaluate(context);
        }
        String conditionString = context.replaceDynamicContentInString(this.condition);
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)conditionString)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher((String)"iteratingCondition", (String)"", (String)conditionString, (TestContext)context);
                return true;
            }
            catch (ValidationException | AssertionError e) {
                return false;
            }
        }
        return BooleanExpressionParser.evaluate(conditionString);
    }

    @Override
    public boolean isDone(TestContext context) {
        return super.isDone(context) || !this.checkCondition(context);
    }

    public String getCondition() {
        return this.condition;
    }

    public ConditionExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public static class Builder
    extends AbstractTestContainerBuilder<Conditional, Builder> {
        protected String condition;
        private ConditionExpression conditionExpression;

        public static Builder conditional() {
            return new Builder();
        }

        public Builder when(String expression) {
            this.condition = expression;
            return this;
        }

        public Builder when(ConditionExpression expression) {
            this.conditionExpression = expression;
            return this;
        }

        @Override
        public Conditional doBuild() {
            return new Conditional(this);
        }
    }
}

