/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BooleanExpressionParser {
    private static final List<String> OPERATORS = new ArrayList<String>(Arrays.asList("lt", "lt=", "gt", "gt=", "<", "<=", ">", ">="));
    private static final List<String> BOOLEAN_OPERATORS = new ArrayList<String>(Arrays.asList("=", "and", "or"));
    private static final List<String> BOOLEAN_VALUES = new ArrayList<String>(Arrays.asList(Boolean.TRUE.toString(), Boolean.FALSE.toString()));
    private static final Logger log = LoggerFactory.getLogger(BooleanExpressionParser.class);

    private BooleanExpressionParser() {
    }

    public static boolean evaluate(String expression) {
        boolean result;
        ArrayDeque<String> operators = new ArrayDeque<String>();
        ArrayDeque<String> values = new ArrayDeque<String>();
        int currentCharacterIndex = 0;
        try {
            while (currentCharacterIndex < expression.length()) {
                char currentCharacter = expression.charAt(currentCharacterIndex);
                if (SeparatorToken.OPEN_PARENTHESIS.value.charValue() == currentCharacter) {
                    operators.push(SeparatorToken.OPEN_PARENTHESIS.toString());
                    currentCharacterIndex += BooleanExpressionParser.moveCursor(SeparatorToken.OPEN_PARENTHESIS.toString());
                    continue;
                }
                if (SeparatorToken.SPACE.value.charValue() == currentCharacter) {
                    currentCharacterIndex += BooleanExpressionParser.moveCursor(SeparatorToken.SPACE.toString());
                    continue;
                }
                if (SeparatorToken.CLOSE_PARENTHESIS.value.charValue() == currentCharacter) {
                    BooleanExpressionParser.evaluateSubexpression(operators, values);
                    currentCharacterIndex += BooleanExpressionParser.moveCursor(SeparatorToken.CLOSE_PARENTHESIS.toString());
                    continue;
                }
                if (!Character.isDigit(currentCharacter)) {
                    String parsedNonDigit = BooleanExpressionParser.parseNonDigits(expression, currentCharacterIndex);
                    if (BooleanExpressionParser.isBoolean(parsedNonDigit).booleanValue()) {
                        values.push(BooleanExpressionParser.replaceBooleanStringByIntegerRepresentation(parsedNonDigit));
                    } else {
                        operators.push(BooleanExpressionParser.validateOperator(parsedNonDigit));
                    }
                    currentCharacterIndex += BooleanExpressionParser.moveCursor(parsedNonDigit);
                    continue;
                }
                if (!Character.isDigit(currentCharacter)) continue;
                String parsedDigits = BooleanExpressionParser.parseDigits(expression, currentCharacterIndex);
                values.push(parsedDigits);
                currentCharacterIndex += BooleanExpressionParser.moveCursor(parsedDigits);
            }
            result = Boolean.valueOf(BooleanExpressionParser.evaluateExpressionStack(operators, values));
            if (log.isDebugEnabled()) {
                log.debug("Boolean expression {} evaluates to {}", (Object)expression, (Object)result);
            }
        }
        catch (NoSuchElementException e) {
            throw new CitrusRuntimeException("Unable to parse boolean expression '" + expression + "'. Maybe expression is incomplete!", (Throwable)e);
        }
        return result;
    }

    private static String evaluateExpressionStack(Deque<String> operators, Deque<String> values) {
        while (!operators.isEmpty()) {
            values.push(BooleanExpressionParser.getBooleanResultAsString(operators.pop(), values.pop(), values.pop()));
        }
        return BooleanExpressionParser.replaceIntegerStringByBooleanRepresentation(values.pop());
    }

    private static void evaluateSubexpression(Deque<String> operators, Deque<String> values) {
        String operator = operators.pop();
        while (!operator.equals(SeparatorToken.OPEN_PARENTHESIS.toString())) {
            values.push(BooleanExpressionParser.getBooleanResultAsString(operator, values.pop(), values.pop()));
            operator = operators.pop();
        }
    }

    private static String parseDigits(String expression, int startIndex) {
        StringBuilder digitBuffer = new StringBuilder();
        char currentCharacter = expression.charAt(startIndex);
        int subExpressionIndex = startIndex;
        do {
            digitBuffer.append(currentCharacter);
            if (++subExpressionIndex >= expression.length()) continue;
            currentCharacter = expression.charAt(subExpressionIndex);
        } while (subExpressionIndex < expression.length() && Character.isDigit(currentCharacter));
        return digitBuffer.toString();
    }

    private static String parseNonDigits(String expression, int startIndex) {
        StringBuilder operatorBuffer = new StringBuilder();
        char currentCharacter = expression.charAt(startIndex);
        int subExpressionIndex = startIndex;
        do {
            operatorBuffer.append(currentCharacter);
            if (++subExpressionIndex >= expression.length()) continue;
            currentCharacter = expression.charAt(subExpressionIndex);
        } while (subExpressionIndex < expression.length() && !Character.isDigit(currentCharacter) && !BooleanExpressionParser.isSeparatorToken(currentCharacter));
        return operatorBuffer.toString();
    }

    private static Boolean isBoolean(String possibleBoolean) {
        return BOOLEAN_VALUES.contains(possibleBoolean);
    }

    private static String replaceBooleanStringByIntegerRepresentation(String possibleBooleanString) {
        if (possibleBooleanString.equals(Boolean.TRUE.toString())) {
            return "1";
        }
        if (possibleBooleanString.equals(Boolean.FALSE.toString())) {
            return "0";
        }
        return possibleBooleanString;
    }

    private static String replaceIntegerStringByBooleanRepresentation(String value) {
        if (value.equals("0")) {
            return Boolean.FALSE.toString();
        }
        if (value.equals("1")) {
            return Boolean.TRUE.toString();
        }
        return value;
    }

    private static boolean isSeparatorToken(char possibleSeparatorChar) {
        for (SeparatorToken token : SeparatorToken.values()) {
            if (token.value.charValue() != possibleSeparatorChar) continue;
            return true;
        }
        return false;
    }

    private static String validateOperator(String operator) {
        if (!OPERATORS.contains(operator) && !BOOLEAN_OPERATORS.contains(operator)) {
            throw new CitrusRuntimeException("Unknown operator '" + operator + "'");
        }
        return operator;
    }

    private static int moveCursor(String lastToken) {
        return lastToken.length();
    }

    private static String getBooleanResultAsString(String operator, String rightOperand, String leftOperand) {
        switch (operator) {
            case "lt": 
            case "<": {
                return Boolean.toString(Integer.valueOf(leftOperand) < Integer.valueOf(rightOperand));
            }
            case "lt=": 
            case "<=": {
                return Boolean.toString(Integer.valueOf(leftOperand) <= Integer.valueOf(rightOperand));
            }
            case "gt": 
            case ">": {
                return Boolean.toString(Integer.valueOf(leftOperand) > Integer.valueOf(rightOperand));
            }
            case "gt=": 
            case ">=": {
                return Boolean.toString(Integer.valueOf(leftOperand) >= Integer.valueOf(rightOperand));
            }
            case "=": {
                return Boolean.toString(Integer.parseInt(leftOperand) == Integer.parseInt(rightOperand));
            }
            case "and": {
                return Boolean.toString(Boolean.valueOf(leftOperand) != false && Boolean.valueOf(rightOperand) != false);
            }
            case "or": {
                return Boolean.toString(Boolean.valueOf(leftOperand) != false || Boolean.valueOf(rightOperand) != false);
            }
        }
        throw new CitrusRuntimeException("Unknown operator '" + operator + "'");
    }

    private static enum SeparatorToken {
        SPACE(Character.valueOf(' ')),
        OPEN_PARENTHESIS(Character.valueOf('(')),
        CLOSE_PARENTHESIS(Character.valueOf(')'));

        private final Character value;

        private SeparatorToken(Character value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

