/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageHeaderUtils;
import com.consol.citrus.validation.AbstractMessageValidator;
import com.consol.citrus.validation.DefaultHeaderValidator;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.context.HeaderValidationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class DefaultMessageHeaderValidator
extends AbstractMessageValidator<HeaderValidationContext> {
    private List<HeaderValidator> validators = new ArrayList<HeaderValidator>();
    private static final Map<String, HeaderValidator> DEFAULT_VALIDATORS = HeaderValidator.lookup();

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, HeaderValidationContext validationContext) {
        Map controlHeaders = controlMessage.getHeaders();
        Map receivedHeaders = receivedMessage.getHeaders();
        if (CollectionUtils.isEmpty((Map)controlHeaders)) {
            return;
        }
        this.log.debug("Start message header validation ...");
        for (Map.Entry entry : controlHeaders.entrySet()) {
            if (MessageHeaderUtils.isSpringInternalHeader((String)((String)entry.getKey())) || ((String)entry.getKey()).startsWith("citrus_message_") || ((String)entry.getKey()).equals("citrus_endpoint_uri") || ((String)entry.getKey()).equals("citrus_request_path") || ((String)entry.getKey()).equals("citrus_query_params")) continue;
            String headerName = this.getHeaderName((String)entry.getKey(), receivedHeaders, context, validationContext);
            if (!receivedHeaders.containsKey(headerName)) {
                throw new ValidationException("Validation failed: Header element '" + headerName + "' is missing");
            }
            Object controlValue = entry.getValue();
            validationContext.getValidators().stream().filter(validator -> validator.supports(headerName, (Class)Optional.ofNullable(controlValue).map(Object::getClass).orElse(null))).findFirst().orElse(validationContext.getValidatorNames().stream().map(beanName -> {
                try {
                    return (HeaderValidator)context.getReferenceResolver().resolve(beanName, HeaderValidator.class);
                }
                catch (CitrusRuntimeException e) {
                    this.log.warn("Failed to resolve header validator for name: " + beanName);
                    return null;
                }
            }).filter(Objects::nonNull).filter(validator -> validator.supports(headerName, (Class)Optional.ofNullable(controlValue).map(Object::getClass).orElse(null))).findFirst().orElse(this.getHeaderValidators(context).stream().filter(validator -> validator.supports(headerName, (Class)Optional.ofNullable(controlValue).map(Object::getClass).orElse(null))).findFirst().orElse(new DefaultHeaderValidator()))).validateHeader(headerName, receivedHeaders.get(headerName), controlValue, context, validationContext);
        }
        this.log.info("Message header validation successful: All values OK");
    }

    private List<HeaderValidator> getHeaderValidators(TestContext context) {
        ArrayList<HeaderValidator> allValidators = new ArrayList<HeaderValidator>(this.validators);
        HashMap<String, HeaderValidator> validatorMap = new HashMap<String, HeaderValidator>(DEFAULT_VALIDATORS);
        validatorMap.putAll(context.getReferenceResolver().resolveAll(HeaderValidator.class));
        allValidators.addAll(validatorMap.values());
        return allValidators.stream().distinct().collect(Collectors.toList());
    }

    private String getHeaderName(String name, Map<String, Object> receivedHeaders, TestContext context, HeaderValidationContext validationContext) {
        String headerName = context.resolveDynamicValue(name);
        if (!receivedHeaders.containsKey(headerName) && validationContext.isHeaderNameIgnoreCase()) {
            String key = headerName;
            this.log.debug(String.format("Finding case insensitive header for key '%s'", key));
            headerName = receivedHeaders.entrySet().parallelStream().filter(item -> ((String)item.getKey()).equalsIgnoreCase(key)).map(Map.Entry::getKey).findFirst().orElseThrow(() -> new ValidationException("Validation failed: No matching header for key '" + key + "'"));
            this.log.info(String.format("Found matching case insensitive header name: %s", headerName));
        }
        return headerName;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return true;
    }

    protected Class<HeaderValidationContext> getRequiredValidationContextType() {
        return HeaderValidationContext.class;
    }

    public void addHeaderValidator(HeaderValidator validator) {
        this.validators.add(validator);
    }

    public List<HeaderValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public void setValidators(List<HeaderValidator> validators) {
        this.validators = validators;
    }
}

