/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContextProvider;
import com.consol.citrus.CitrusInstanceProcessor;
import com.consol.citrus.CitrusInstanceStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CitrusInstanceManager {
    private static Citrus citrus;
    private static final List<CitrusInstanceProcessor> instanceProcessors;
    protected static CitrusInstanceStrategy strategy;

    public static void addInstanceProcessor(CitrusInstanceProcessor processor) {
        instanceProcessors.add(processor);
    }

    public static Citrus newInstance() {
        return CitrusInstanceManager.newInstance(CitrusContextProvider.lookup());
    }

    public static Citrus newInstance(CitrusContextProvider contextProvider) {
        if (strategy.equals((Object)CitrusInstanceStrategy.NEW) || citrus == null) {
            citrus = new Citrus(contextProvider.create());
            instanceProcessors.forEach(processor -> processor.process(citrus));
        }
        return citrus;
    }

    public static void mode(CitrusInstanceStrategy mode) {
        strategy = mode;
    }

    public static Optional<Citrus> get() {
        return Optional.ofNullable(citrus);
    }

    public static Citrus getOrDefault() {
        if (citrus == null) {
            citrus = CitrusInstanceManager.newInstance();
        }
        return citrus;
    }

    public static boolean hasInstance() {
        return citrus != null;
    }

    public static void reset() {
        citrus = null;
    }

    static {
        instanceProcessors = new ArrayList<CitrusInstanceProcessor>();
        strategy = CitrusInstanceStrategy.NEW;
    }
}

