/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.actions.NoopTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.functions.FunctionUtils;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.variable.VariableUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template
extends AbstractTestAction {
    private final List<TestActionBuilder<?>> actions;
    private final String templateName;
    private final Map<String, String> parameter;
    private final boolean globalContext;
    private static final Logger log = LoggerFactory.getLogger(Template.class);

    public Template(AbstractTemplateBuilder<? extends Template, ?> builder) {
        super(Optional.ofNullable(builder.templateName).map(name -> "template:" + name).orElse("template"), builder);
        this.templateName = builder.templateName;
        this.actions = builder.actions;
        this.parameter = builder.parameter;
        this.globalContext = builder.globalContext;
    }

    @Override
    public void doExecute(TestContext context) {
        TestContext innerContext;
        if (log.isDebugEnabled()) {
            log.debug("Executing template '" + this.getName() + "' with " + this.actions.size() + " embedded actions");
        }
        if (this.globalContext) {
            innerContext = context;
        } else {
            innerContext = new TestContext();
            innerContext.setFunctionRegistry(context.getFunctionRegistry());
            innerContext.setGlobalVariables(new GlobalVariables.Builder().variables(context.getGlobalVariables()).build());
            innerContext.getVariables().putAll(context.getVariables());
            innerContext.setMessageStore(context.getMessageStore());
            innerContext.setMessageValidatorRegistry(context.getMessageValidatorRegistry());
            innerContext.setValidationMatcherRegistry(context.getValidationMatcherRegistry());
            innerContext.setTestListeners(context.getTestListeners());
            innerContext.setMessageListeners(context.getMessageListeners());
            innerContext.setMessageProcessors(context.getMessageProcessors());
            innerContext.setEndpointFactory(context.getEndpointFactory());
            innerContext.setNamespaceContextBuilder(context.getNamespaceContextBuilder());
            innerContext.setReferenceResolver(context.getReferenceResolver());
            innerContext.setTypeConverter(context.getTypeConverter());
            innerContext.setLogModifier(context.getLogModifier());
        }
        for (Map.Entry<String, String> entry : this.parameter.entrySet()) {
            String param = entry.getKey();
            String paramValue = entry.getValue();
            paramValue = VariableUtils.replaceVariablesInString((String)paramValue, (TestContext)innerContext, (boolean)false);
            if (context.getFunctionRegistry().isFunction(paramValue)) {
                paramValue = FunctionUtils.resolveFunction((String)paramValue, (TestContext)context);
            }
            if (log.isDebugEnabled()) {
                log.debug("Setting parameter for template " + param + "=" + paramValue);
            }
            innerContext.setVariable(param, (Object)paramValue);
        }
        for (TestActionBuilder testActionBuilder : this.actions) {
            testActionBuilder.build().execute(innerContext);
        }
        log.info("Template was executed successfully");
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public boolean isGlobalContext() {
        return this.globalContext;
    }

    public List<TestAction> getActions() {
        return this.actions.stream().map(TestActionBuilder::build).collect(Collectors.toList());
    }

    public List<TestActionBuilder<?>> getActionBuilders() {
        return this.actions;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public static abstract class AbstractTemplateBuilder<T extends Template, B extends AbstractTemplateBuilder<T, B>>
    extends AbstractTestActionBuilder<T, B> {
        private String templateName;
        private final List<TestActionBuilder<?>> actions = new ArrayList();
        private final Map<String, String> parameter = new LinkedHashMap<String, String>();
        private boolean globalContext = true;
        private ReferenceResolver referenceResolver;

        public B templateName(String templateName) {
            this.templateName = templateName;
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B globalContext(boolean globalContext) {
            this.globalContext = globalContext;
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B parameters(Map<String, String> parameters) {
            this.parameter.putAll(parameters);
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B parameter(String name, String value) {
            this.parameter.put(name, value);
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B actions(TestAction ... actions) {
            return this.actions(Arrays.asList(actions));
        }

        public B actions(List<TestAction> actions) {
            return this.actions(actions.stream().filter(action -> !(action instanceof NoopTestAction)).map(action -> () -> action).collect(Collectors.toList()).toArray(new TestActionBuilder[0]));
        }

        public B actions(TestActionBuilder<?> ... actions) {
            for (int i = 0; i < actions.length; ++i) {
                TestActionBuilder<?> current = actions[i];
                if (current.build() instanceof NoopTestAction) continue;
                if (this.actions.size() == i) {
                    this.actions.add(current);
                    continue;
                }
                if (this.resolveActionBuilder(this.actions.get(i)).equals(this.resolveActionBuilder(current))) continue;
                this.actions.add(i, current);
            }
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public B withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return (B)((AbstractTemplateBuilder)this.self);
        }

        public List<TestActionBuilder<?>> getActions() {
            return this.actions;
        }

        protected void onBuild() {
            if (this.referenceResolver != null && this.templateName != null) {
                Template rootTemplate = (Template)this.referenceResolver.resolve(this.templateName, Template.class);
                this.globalContext(rootTemplate.isGlobalContext() && this.globalContext);
                this.actor(Optional.ofNullable(this.getActor()).orElse(rootTemplate.getActor()));
                LinkedHashMap<String, String> mergedParameters = new LinkedHashMap<String, String>();
                mergedParameters.putAll(rootTemplate.getParameter());
                mergedParameters.putAll(this.parameter);
                this.parameters(mergedParameters);
                this.actions((TestActionBuilder[])rootTemplate.getActionBuilders().toArray(TestActionBuilder[]::new));
            }
        }

        private TestActionBuilder<?> resolveActionBuilder(TestActionBuilder<?> builder) {
            if (builder instanceof TestActionBuilder.DelegatingTestActionBuilder) {
                return this.resolveActionBuilder(((TestActionBuilder.DelegatingTestActionBuilder)builder).getDelegate());
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractTemplateBuilder<Template, Builder> {
        public static Builder applyTemplate(String name) {
            Builder builder = new Builder();
            builder.templateName(name);
            return builder;
        }

        public Template build() {
            this.onBuild();
            return new Template(this);
        }
    }
}

