/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.validation.context.DefaultValidationContext;
import com.consol.citrus.validation.context.SchemaValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JsonMessageValidationContext
extends DefaultValidationContext
implements SchemaValidationContext {
    private final Set<String> ignoreExpressions;
    private final boolean schemaValidation;
    private final String schemaRepository;
    private final String schema;

    public JsonMessageValidationContext() {
        this(new Builder());
    }

    public JsonMessageValidationContext(Builder builder) {
        this.ignoreExpressions = builder.ignoreExpressions;
        this.schemaValidation = builder.schemaValidation;
        this.schemaRepository = builder.schemaRepository;
        this.schema = builder.schema;
    }

    public Set<String> getIgnoreExpressions() {
        return this.ignoreExpressions;
    }

    public boolean isSchemaValidationEnabled() {
        return this.schemaValidation;
    }

    public String getSchemaRepository() {
        return this.schemaRepository;
    }

    public String getSchema() {
        return this.schema;
    }

    public static final class Builder
    implements ValidationContext.Builder<JsonMessageValidationContext, Builder>,
    SchemaValidationContext.Builder<Builder> {
        private final Set<String> ignoreExpressions = new HashSet<String>();
        private boolean schemaValidation = true;
        private String schemaRepository;
        private String schema;

        public static Builder json() {
            return new Builder();
        }

        public Builder schemaValidation(boolean enabled) {
            this.schemaValidation = enabled;
            return this;
        }

        public Builder schema(String schemaName) {
            this.schema = schemaName;
            return this;
        }

        public Builder schemaRepository(String schemaRepository) {
            this.schemaRepository = schemaRepository;
            return this;
        }

        public Builder ignore(String path) {
            this.ignoreExpressions.add(path);
            return this;
        }

        public Builder ignore(List<String> paths) {
            this.ignoreExpressions.addAll(paths);
            return this;
        }

        public JsonMessageValidationContext build() {
            return new JsonMessageValidationContext(this);
        }
    }
}

